/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support.header;

import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.exchange.support.header.AbstractTimerTask;

public class CloseTimerTask
extends AbstractTimerTask {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(CloseTimerTask.class);
    private final int closeTimeout;

    public CloseTimerTask(AbstractTimerTask.ChannelProvider channelProvider, HashedWheelTimer hashedWheelTimer, Long tick, int closeTimeout) {
        super(channelProvider, hashedWheelTimer, tick);
        this.closeTimeout = closeTimeout;
        this.start();
    }

    @Override
    protected void doTask(Channel channel) {
        try {
            Long lastRead = CloseTimerTask.lastRead(channel);
            Long lastWrite = CloseTimerTask.lastWrite(channel);
            Long now = CloseTimerTask.now();
            if (lastRead != null && now - lastRead > (long)this.closeTimeout || lastWrite != null && now - lastWrite > (long)this.closeTimeout) {
                logger.warn("4-14", "", "", "Close channel " + channel + ", because idleCheck timeout: " + this.closeTimeout + "ms");
                channel.close();
            }
        }
        catch (Throwable t) {
            logger.warn("6-3", "", "", "Exception when close remote channel " + channel.getRemoteAddress(), t);
        }
    }
}

