/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.Collection;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.Cmd;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.remoting.exchange.ExchangeChannel;
import org.apache.dubbo.remoting.exchange.ExchangeServer;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.protocol.dubbo.DubboProtocol;

@Cmd(name="ps", summary="Print server ports and connections.", example={"ps -l [port]", "ps", "ps -l", "ps -l 20880"})
public class PortTelnet
implements BaseCommand {
    private final DubboProtocol dubboProtocol;

    public PortTelnet(FrameworkModel frameworkModel) {
        this.dubboProtocol = DubboProtocol.getDubboProtocol((ScopeModel)frameworkModel);
    }

    public String execute(CommandContext commandContext, String[] args) {
        StringBuilder buf = new StringBuilder();
        String port = null;
        boolean detail = false;
        if (args.length > 0) {
            for (String part : args) {
                if ("-l".equals(part)) {
                    detail = true;
                    continue;
                }
                if (!StringUtils.isNumber((String)part)) {
                    return "Illegal port " + (String)part + ", must be integer.";
                }
                port = part;
            }
        }
        if (StringUtils.isEmpty(port)) {
            for (ProtocolServer server : this.dubboProtocol.getServers()) {
                if (buf.length() > 0) {
                    buf.append("\r\n");
                }
                if (detail) {
                    buf.append(server.getUrl().getProtocol()).append("://").append(server.getUrl().getAddress());
                    continue;
                }
                buf.append(server.getUrl().getPort());
            }
        } else {
            int p = Integer.parseInt(port);
            ProtocolServer protocolServer = null;
            for (ProtocolServer s : this.dubboProtocol.getServers()) {
                if (p != s.getUrl().getPort()) continue;
                protocolServer = s;
                break;
            }
            if (protocolServer != null) {
                ExchangeServer server = (ExchangeServer)protocolServer.getRemotingServer();
                Collection channels = server.getExchangeChannels();
                for (ExchangeChannel c : channels) {
                    if (buf.length() > 0) {
                        buf.append("\r\n");
                    }
                    if (detail) {
                        buf.append(c.getRemoteAddress()).append(" -> ").append(c.getLocalAddress());
                        continue;
                    }
                    buf.append(c.getRemoteAddress());
                }
            } else {
                buf.append("No such port ").append(port);
            }
        }
        return buf.toString();
    }
}

