/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceMetadata;

public class BaseOffline
implements BaseCommand {
    private static final Logger logger = LoggerFactory.getLogger(BaseOffline.class);
    public FrameworkServiceRepository serviceRepository;

    public BaseOffline(FrameworkModel frameworkModel) {
        this.serviceRepository = frameworkModel.getServiceRepository();
    }

    public String execute(CommandContext commandContext, String[] args) {
        boolean hasService;
        logger.info("receive offline command");
        String servicePattern = ".*";
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            servicePattern = args[0];
        }
        if (hasService = this.doExecute(servicePattern)) {
            return "OK";
        }
        return "service not found";
    }

    protected boolean doExecute(String servicePattern) {
        return this.offline(servicePattern);
    }

    public boolean offline(String servicePattern) {
        boolean hasService = false;
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), 4), (ThreadFactory)new NamedThreadFactory("Dubbo-Offline"));
        try {
            LinkedList<CompletableFuture<Void>> futures = new LinkedList<CompletableFuture<Void>>();
            List providerModelList = this.serviceRepository.allProviderModels();
            for (ProviderModel providerModel : providerModelList) {
                ServiceMetadata metadata = providerModel.getServiceMetadata();
                if (!metadata.getServiceKey().matches(servicePattern) && !metadata.getDisplayServiceKey().matches(servicePattern)) continue;
                hasService = true;
                List statedUrls = providerModel.getStatedUrl();
                for (ProviderModel.RegisterStatedURL statedURL : statedUrls) {
                    if (!statedURL.isRegistered()) continue;
                    futures.add(CompletableFuture.runAsync(() -> this.doUnexport(statedURL), executorService));
                }
            }
            for (CompletableFuture completableFuture : futures) {
                completableFuture.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            executorService.shutdown();
        }
        return hasService;
    }

    protected void doUnexport(ProviderModel.RegisterStatedURL statedURL) {
        RegistryFactory registryFactory = (RegistryFactory)statedURL.getRegistryUrl().getOrDefaultApplicationModel().getExtensionLoader(RegistryFactory.class).getAdaptiveExtension();
        Registry registry = registryFactory.getRegistry(statedURL.getRegistryUrl());
        registry.unregister(statedURL.getProviderUrl());
        statedURL.setRegistered(false);
    }
}

