/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.aot.generate;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.dubbo.aot.api.JdkProxyDescriber;
import org.apache.dubbo.aot.api.ProxyDescriberRegistrar;
import org.apache.dubbo.aot.api.ReflectionTypeDescriberRegistrar;
import org.apache.dubbo.aot.api.ResourceBundleDescriber;
import org.apache.dubbo.aot.api.ResourceDescriberRegistrar;
import org.apache.dubbo.aot.api.ResourcePatternDescriber;
import org.apache.dubbo.aot.api.TypeDescriber;
import org.apache.dubbo.aot.generate.ClassSourceScanner;
import org.apache.dubbo.aot.generate.NativeClassSourceWriter;
import org.apache.dubbo.aot.generate.NativeConfigurationWriter;
import org.apache.dubbo.aot.generate.ProxyConfigMetadataRepository;
import org.apache.dubbo.aot.generate.ReflectConfigMetadataRepository;
import org.apache.dubbo.aot.generate.ResourceConfigMetadataRepository;
import org.apache.dubbo.aot.generate.ResourceScanner;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class AotProcessor {
    public static void main(String[] args) {
        String generatedSources = args[1];
        List<Class<?>> classes = ClassSourceScanner.INSTANCE.spiClassesWithAdaptive();
        NativeClassSourceWriter.INSTANCE.writeTo(classes, generatedSources);
        NativeConfigurationWriter writer = new NativeConfigurationWriter(Paths.get(args[2], new String[0]), args[4], args[5]);
        ResourceConfigMetadataRepository resourceRepository = new ResourceConfigMetadataRepository();
        resourceRepository.registerIncludesPatterns(ResourceScanner.INSTANCE.distinctSpiResource().toArray(new String[0]));
        resourceRepository.registerIncludesPatterns(ResourceScanner.INSTANCE.distinctSecurityResource().toArray(new String[0]));
        for (ResourcePatternDescriber resourcePatternDescriber : AotProcessor.getResourcePatternDescribers()) {
            resourceRepository.registerIncludesPattern(resourcePatternDescriber);
        }
        for (ResourceBundleDescriber resourceBundleDescriber : AotProcessor.getResourceBundleDescribers()) {
            resourceRepository.registerBundles(resourceBundleDescriber);
        }
        writer.writeResourceConfig(resourceRepository);
        ReflectConfigMetadataRepository reflectRepository = new ReflectConfigMetadataRepository();
        reflectRepository.registerSpiExtensionType(new ArrayList(ClassSourceScanner.INSTANCE.distinctSpiExtensionClasses(ResourceScanner.INSTANCE.distinctSpiResource()).values())).registerAdaptiveType(new ArrayList(ClassSourceScanner.INSTANCE.adaptiveClasses().values())).registerBeanType(ClassSourceScanner.INSTANCE.scopeModelInitializer()).registerConfigType(ClassSourceScanner.INSTANCE.configClasses()).registerFieldType(AotProcessor.getCustomClasses()).registerTypeDescriber(AotProcessor.getTypes());
        writer.writeReflectionConfig(reflectRepository);
        ProxyConfigMetadataRepository proxyRepository = new ProxyConfigMetadataRepository();
        proxyRepository.registerProxyDescribers(AotProcessor.getProxyDescribers());
        writer.writeProxyConfig(proxyRepository);
    }

    private static List<TypeDescriber> getTypes() {
        ArrayList<TypeDescriber> typeDescribers = new ArrayList<TypeDescriber>();
        FrameworkModel.defaultModel().defaultApplication().getExtensionLoader(ReflectionTypeDescriberRegistrar.class).getSupportedExtensionInstances().forEach(reflectionTypeDescriberRegistrar -> {
            List<Object> describers = new ArrayList();
            try {
                describers = reflectionTypeDescriberRegistrar.getTypeDescribers();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            typeDescribers.addAll(describers);
        });
        return typeDescribers;
    }

    private static List<ResourcePatternDescriber> getResourcePatternDescribers() {
        ArrayList<ResourcePatternDescriber> resourcePatternDescribers = new ArrayList<ResourcePatternDescriber>();
        FrameworkModel.defaultModel().defaultApplication().getExtensionLoader(ResourceDescriberRegistrar.class).getSupportedExtensionInstances().forEach(reflectionTypeDescriberRegistrar -> {
            List<Object> describers = new ArrayList();
            try {
                describers = reflectionTypeDescriberRegistrar.getResourcePatternDescribers();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            resourcePatternDescribers.addAll(describers);
        });
        return resourcePatternDescribers;
    }

    private static List<ResourceBundleDescriber> getResourceBundleDescribers() {
        ArrayList<ResourceBundleDescriber> resourceBundleDescribers = new ArrayList<ResourceBundleDescriber>();
        FrameworkModel.defaultModel().defaultApplication().getExtensionLoader(ResourceDescriberRegistrar.class).getSupportedExtensionInstances().forEach(reflectionTypeDescriberRegistrar -> {
            List<Object> describers = new ArrayList();
            try {
                describers = reflectionTypeDescriberRegistrar.getResourceBundleDescribers();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            resourceBundleDescribers.addAll(describers);
        });
        return resourceBundleDescribers;
    }

    private static List<JdkProxyDescriber> getProxyDescribers() {
        ArrayList<JdkProxyDescriber> jdkProxyDescribers = new ArrayList<JdkProxyDescriber>();
        FrameworkModel.defaultModel().defaultApplication().getExtensionLoader(ProxyDescriberRegistrar.class).getSupportedExtensionInstances().forEach(reflectionTypeDescriberRegistrar -> jdkProxyDescribers.addAll(reflectionTypeDescriberRegistrar.getJdkProxyDescribers()));
        return jdkProxyDescribers;
    }

    private static List<Class<?>> getCustomClasses() {
        Class[] configClasses = new Class[]{CommonConstants.SystemProperty.class, CommonConstants.ThirdPartyProperty.class, CommonConstants.DubboProperty.class};
        return new ArrayList(Arrays.asList(configClasses));
    }
}

