/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.aot.generate;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.aot.generate.BasicJsonWriter;
import org.apache.dubbo.aot.generate.ConditionalDescriber;
import org.apache.dubbo.aot.generate.ResourceBundleDescriber;
import org.apache.dubbo.aot.generate.ResourceConfigMetadataRepository;
import org.apache.dubbo.aot.generate.ResourcePatternDescriber;

public class ResourceConfigWriter {
    public static final ResourceConfigWriter INSTANCE = new ResourceConfigWriter();

    public void write(BasicJsonWriter writer, ResourceConfigMetadataRepository repository) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.addIfNotEmpty(attributes, "resources", this.toAttributes(repository.getIncludes(), repository.getExcludes()));
        this.handleResourceBundles(attributes, repository.getResourceBundles());
        writer.writeObject(attributes);
    }

    private Map<String, Object> toAttributes(List<ResourcePatternDescriber> includes, List<ResourcePatternDescriber> excludes) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.addIfNotEmpty(attributes, "includes", includes.stream().distinct().map(this::toAttributes).collect(Collectors.toList()));
        this.addIfNotEmpty(attributes, "excludes", excludes.stream().distinct().map(this::toAttributes).collect(Collectors.toList()));
        return attributes;
    }

    private void handleResourceBundles(Map<String, Object> attributes, Set<ResourceBundleDescriber> resourceBundleDescribers) {
        this.addIfNotEmpty(attributes, "bundles", resourceBundleDescribers.stream().map(this::toAttributes).collect(Collectors.toList()));
    }

    private Map<String, Object> toAttributes(ResourceBundleDescriber describer) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.handleCondition(attributes, describer);
        attributes.put("name", describer.getName());
        return attributes;
    }

    private Map<String, Object> toAttributes(ResourcePatternDescriber describer) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.handleCondition(attributes, describer);
        attributes.put("pattern", describer.toRegex().toString());
        return attributes;
    }

    private void addIfNotEmpty(Map<String, Object> attributes, String name, Object value) {
        if (value instanceof Collection) {
            if (!((Collection)value).isEmpty()) {
                attributes.put(name, value);
            }
        } else if (value instanceof Map) {
            if (!((Map)value).isEmpty()) {
                attributes.put(name, value);
            }
        } else if (value != null) {
            attributes.put(name, value);
        }
    }

    private void handleCondition(Map<String, Object> attributes, ConditionalDescriber conditionalDescriber) {
        if (conditionalDescriber.getReachableType() != null) {
            LinkedHashMap<String, String> conditionAttributes = new LinkedHashMap<String, String>();
            conditionAttributes.put("typeReachable", conditionalDescriber.getReachableType());
            attributes.put("condition", conditionAttributes);
        }
    }
}

