/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.builder;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import org.apache.dubbo.metadata.annotation.processing.builder.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.annotation.processing.util.MethodUtils;
import org.apache.dubbo.metadata.definition.model.MethodDefinition;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public interface MethodDefinitionBuilder {
    public static MethodDefinition build(ProcessingEnvironment processingEnv, ExecutableElement method, Map<String, TypeDefinition> typeCache) {
        MethodDefinition methodDefinition = new MethodDefinition();
        methodDefinition.setName(MethodUtils.getMethodName(method));
        methodDefinition.setReturnType(MethodUtils.getReturnType(method));
        methodDefinition.setParameterTypes(MethodUtils.getMethodParameterTypes(method));
        methodDefinition.setParameters(MethodDefinitionBuilder.getMethodParameters(processingEnv, method, typeCache));
        return methodDefinition;
    }

    public static List<TypeDefinition> getMethodParameters(ProcessingEnvironment processingEnv, ExecutableElement method, Map<String, TypeDefinition> typeCache) {
        return method.getParameters().stream().map(element -> TypeDefinitionBuilder.build(processingEnv, element, typeCache)).collect(Collectors.toList());
    }
}

