/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.dubbo.metadata.annotation.processing.util.LoggerUtils;

public class ClassPathMetadataStorage {
    private final Filer filer;

    public ClassPathMetadataStorage(ProcessingEnvironment processingEnv) {
        this.filer = processingEnv.getFiler();
    }

    public void write(Supplier<String> contentSupplier, String resourceName) {
        try (Writer writer = this.getWriter(resourceName);){
            writer.write(contentSupplier.get());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> Optional<T> read(String resourceName, Function<Reader, T> consumer) {
        if (this.exists(resourceName)) {
            Optional<T> optional;
            block9: {
                Reader reader = this.getReader(resourceName);
                try {
                    optional = Optional.ofNullable(consumer.apply(reader));
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                reader.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    private boolean exists(String resourceName) {
        return this.getResource(resourceName).map(FileObject::toUri).map(File::new).map(File::exists).orElse(false);
    }

    private Reader getReader(String resourceName) {
        return this.getResource(resourceName).map(fileObject -> {
            try {
                return fileObject.openReader(false);
            }
            catch (IOException iOException) {
                return null;
            }
        }).orElse(null);
    }

    private FileObject createResource(String resourceName) throws IOException {
        return this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceName, new Element[0]);
    }

    private Optional<FileObject> getResource(String resourceName) {
        try {
            FileObject fileObject = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceName);
            return Optional.ofNullable(fileObject);
        }
        catch (IOException e) {
            LoggerUtils.warn(e.getMessage(), new Object[0]);
            return Optional.empty();
        }
    }

    private Writer getWriter(String resourceName) throws IOException {
        FileObject fileObject = this.createResource(resourceName);
        LoggerUtils.info("The resource[path : %s , deleted : %s] will be written", fileObject.toUri().getPath(), fileObject.delete());
        return fileObject.openWriter();
    }
}

