/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.rest;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.apache.dubbo.common.convert.ConverterUtil;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.metadata.annotation.processing.rest.AbstractServiceRestMetadataResolver;
import org.apache.dubbo.metadata.annotation.processing.rest.jaxrs.JAXRSServiceRestMetadataResolver;
import org.apache.dubbo.metadata.annotation.processing.rest.springmvc.SpringMvcServiceRestMetadataResolver;
import org.apache.dubbo.metadata.annotation.processing.util.LoggerUtils;
import org.apache.dubbo.metadata.annotation.processing.util.ServiceAnnotationUtils;
import org.apache.dubbo.metadata.annotation.processing.util.TypeUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class DefaultServiceRestMetadataResolver
extends AbstractServiceRestMetadataResolver {
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char PATH_SEPARATOR = '/';
    private static final String HTTP_REQUEST_METHOD = "POST";
    private static final List<String> MEDIA_TYPES = Arrays.asList("application/json;", "application/*+json", "application/xml;charset=UTF-8", "text/xml;charset=UTF-8", "application/*+xml;charset=UTF-8");
    private final Set<ExecutableElement> hasComplexParameterTypeMethods = new HashSet<ExecutableElement>();

    @Override
    public boolean supports(ProcessingEnvironment processingEnvironment, TypeElement serviceType) {
        return !JAXRSServiceRestMetadataResolver.supports(serviceType) && !SpringMvcServiceRestMetadataResolver.supports(serviceType);
    }

    @Override
    protected boolean supports(ProcessingEnvironment processingEnv, TypeElement serviceType, TypeElement serviceInterfaceType, ExecutableElement method) {
        return true;
    }

    @Override
    protected String resolveRequestPath(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method) {
        AnnotationMirror serviceAnnotation = ServiceAnnotationUtils.getAnnotation(serviceType);
        String serviceInterfaceName = ServiceAnnotationUtils.resolveServiceInterfaceName(serviceType, serviceAnnotation);
        TypeMirror serviceInterface = TypeUtils.findInterface(serviceType.asType(), serviceInterfaceName);
        StringBuilder requestPathBuilder = new StringBuilder();
        String rootPath = this.buildRootPath(serviceInterface);
        String subPath = this.buildSubPath(method);
        requestPathBuilder.append(rootPath).append(subPath);
        List<? extends VariableElement> parameters = method.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            String parameterName;
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameter.asType();
            if (this.isComplexType(parameterType)) {
                if (this.addComplexParameterType(method)) continue;
                LoggerUtils.warn("The method[%s] contains more than one complex parameter type, thus it will not be chosen as the REST service", method.toString());
            }
            String pathVariableName = this.isEnabledParametersCompilerOption(parameterName = parameter.getSimpleName().toString()) ? parameterName : String.valueOf(i);
            requestPathBuilder.append('/').append('{').append(pathVariableName).append('}');
        }
        return requestPathBuilder.toString();
    }

    private String buildRootPath(TypeMirror serviceInterface) {
        return '/' + serviceInterface.toString().replace('.', '/');
    }

    private String buildSubPath(ExecutableElement method) {
        return '/' + method.getSimpleName().toString();
    }

    private boolean isEnabledParametersCompilerOption(String parameterName) {
        return !parameterName.startsWith("arg");
    }

    private boolean isComplexType(TypeMirror parameterType) {
        return !this.supportsPathVariableType(parameterType);
    }

    private boolean supportsPathVariableType(TypeMirror parameterType) {
        boolean supported;
        String className = parameterType.toString();
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Class targetType = ClassUtils.forName((String)className, (ClassLoader)classLoader);
            supported = ((ConverterUtil)FrameworkModel.defaultModel().getBeanFactory().getBean(ConverterUtil.class)).getConverter(String.class, targetType) != null;
        }
        catch (ClassNotFoundException e) {
            supported = false;
        }
        return supported;
    }

    @Override
    protected String resolveRequestMethod(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method) {
        return HTTP_REQUEST_METHOD;
    }

    @Override
    protected void processProduces(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method, Set<String> produces) {
        TypeMirror returnType = method.getReturnType();
        if (this.isComplexType(returnType)) {
            produces.addAll(MEDIA_TYPES);
        }
    }

    @Override
    protected void processConsumes(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method, Set<String> consumes) {
        if (this.hasComplexParameterType(method)) {
            consumes.addAll(MEDIA_TYPES);
        }
    }

    private boolean addComplexParameterType(ExecutableElement method) {
        return this.hasComplexParameterTypeMethods.add(method);
    }

    private boolean hasComplexParameterType(ExecutableElement method) {
        return this.hasComplexParameterTypeMethods.remove(method);
    }
}

