/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.InstanceMetadataChangedListener;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.remoting.http12.rest.Mapping;
import org.apache.dubbo.remoting.http12.rest.OpenAPI;
import org.apache.dubbo.remoting.http12.rest.OpenAPIRequest;

@OpenAPI(hidden="true")
public interface MetadataService {
    public static final String ALL_SERVICE_INTERFACES = "*";
    public static final String VERSION = "1.0.0";

    public String serviceName();

    default public String version() {
        return VERSION;
    }

    public URL getMetadataURL();

    default public SortedSet<String> getSubscribedURLs() {
        throw new UnsupportedOperationException("This operation is not supported for consumer.");
    }

    default public SortedSet<String> getExportedURLs() {
        return this.getExportedURLs(ALL_SERVICE_INTERFACES);
    }

    default public SortedSet<String> getExportedURLs(String serviceInterface) {
        return this.getExportedURLs(serviceInterface, null);
    }

    default public SortedSet<String> getExportedURLs(String serviceInterface, String group) {
        return this.getExportedURLs(serviceInterface, group, null);
    }

    default public SortedSet<String> getExportedURLs(String serviceInterface, String group, String version) {
        return this.getExportedURLs(serviceInterface, group, version, null);
    }

    public SortedSet<String> getExportedURLs(String var1, String var2, String var3, String var4);

    default public Set<URL> getExportedServiceURLs() {
        return Collections.emptySet();
    }

    default public String getServiceDefinition(String interfaceName, String version, String group) {
        return this.getServiceDefinition(URL.buildKey((String)interfaceName, (String)group, (String)version));
    }

    public String getServiceDefinition(String var1);

    public MetadataInfo getMetadataInfo(String var1);

    public List<MetadataInfo> getMetadataInfos();

    public static SortedSet<String> toSortedStrings(Iterable<URL> iterable) {
        return MetadataService.toSortedStrings(StreamSupport.stream(iterable.spliterator(), false));
    }

    public static SortedSet<String> toSortedStrings(Stream<URL> stream) {
        return Collections.unmodifiableSortedSet(stream.map(URL::toFullString).collect(TreeSet::new, Set::add, Set::addAll));
    }

    public static boolean isMetadataService(String interfaceName) {
        return interfaceName != null && interfaceName.equals(MetadataService.class.getName());
    }

    @Mapping(enabled=false)
    public void exportInstanceMetadata(String var1);

    @Mapping(enabled=false)
    public Map<String, InstanceMetadataChangedListener> getInstanceMetadataChangedListenerMap();

    @Mapping(enabled=false)
    public String getAndListenInstanceMetadata(String var1, InstanceMetadataChangedListener var2);

    @Mapping(value={"//${dubbo.protocol.triple.rest.openapi.path:dubbo/openapi}/{*path}"})
    public String getOpenAPI(OpenAPIRequest var1);
}

