/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.dubbo.common.ProtocolServiceKey;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.url.component.URLParam;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataParamsFilter;
import org.apache.dubbo.metadata.RevisionResolver;

public class MetadataInfo
implements Serializable {
    public static final MetadataInfo EMPTY = new MetadataInfo();
    private static final Logger logger = LoggerFactory.getLogger(MetadataInfo.class);
    private String app;
    private volatile String revision;
    private final Map<String, ServiceInfo> services;
    private transient AtomicBoolean initiated = new AtomicBoolean(false);
    private volatile transient String rawMetadataInfo;
    private transient Map<String, Set<ServiceInfo>> subscribedServices;
    private final transient Map<String, String> extendParams;
    private final transient Map<String, String> instanceParams;
    protected volatile transient boolean updated = false;
    private transient ConcurrentNavigableMap<String, SortedSet<URL>> subscribedServiceURLs;
    private transient ConcurrentNavigableMap<String, SortedSet<URL>> exportedServiceURLs;
    private transient ExtensionLoader<MetadataParamsFilter> loader;

    public MetadataInfo() {
        this(null);
    }

    public MetadataInfo(String app) {
        this(app, null, null);
    }

    public MetadataInfo(String app, String revision, Map<String, ServiceInfo> services) {
        this.app = app;
        this.revision = revision;
        this.services = services == null ? new ConcurrentHashMap() : services;
        this.extendParams = new ConcurrentHashMap<String, String>();
        this.instanceParams = new ConcurrentHashMap<String, String>();
    }

    private MetadataInfo(String app, String revision, Map<String, ServiceInfo> services, AtomicBoolean initiated, Map<String, String> extendParams, Map<String, String> instanceParams, boolean updated, ConcurrentNavigableMap<String, SortedSet<URL>> subscribedServiceURLs, ConcurrentNavigableMap<String, SortedSet<URL>> exportedServiceURLs, ExtensionLoader<MetadataParamsFilter> loader) {
        this.app = app;
        this.revision = revision;
        this.services = new ConcurrentHashMap<String, ServiceInfo>(services);
        this.initiated = new AtomicBoolean(initiated.get());
        this.extendParams = new ConcurrentHashMap<String, String>(extendParams);
        this.instanceParams = new ConcurrentHashMap<String, String>(instanceParams);
        this.updated = updated;
        this.subscribedServiceURLs = subscribedServiceURLs == null ? null : new ConcurrentSkipListMap<String, SortedSet<URL>>((SortedMap<String, SortedSet<URL>>)subscribedServiceURLs);
        this.exportedServiceURLs = exportedServiceURLs == null ? null : new ConcurrentSkipListMap<String, SortedSet<URL>>((SortedMap<String, SortedSet<URL>>)exportedServiceURLs);
        this.loader = loader;
    }

    public void init() {
        if (!this.initiated.compareAndSet(false, true)) {
            return;
        }
        if (CollectionUtils.isNotEmptyMap(this.services)) {
            this.services.forEach((_k, serviceInfo) -> {
                serviceInfo.init();
                if (this.subscribedServices == null) {
                    this.subscribedServices = new HashMap<String, Set<ServiceInfo>>();
                }
                Set serviceInfos = this.subscribedServices.computeIfAbsent(serviceInfo.getServiceKey(), _key -> new HashSet());
                serviceInfos.add(serviceInfo);
            });
        }
    }

    public synchronized void addService(URL url) {
        if (this.loader == null) {
            this.loader = url.getOrDefaultApplicationModel().getExtensionLoader(MetadataParamsFilter.class);
        }
        List filters = this.loader.getActivateExtension(url, "params-filter");
        ServiceInfo serviceInfo = new ServiceInfo(url, filters);
        this.services.put(serviceInfo.getMatchKey(), serviceInfo);
        this.extractInstanceParams(url, filters);
        if (this.exportedServiceURLs == null) {
            this.exportedServiceURLs = new ConcurrentSkipListMap<String, SortedSet<URL>>();
        }
        this.addURL(this.exportedServiceURLs, url);
        this.updated = true;
    }

    public synchronized void removeService(URL url) {
        if (url == null) {
            return;
        }
        this.services.remove(url.getProtocolServiceKey());
        if (this.exportedServiceURLs != null) {
            this.removeURL(this.exportedServiceURLs, url);
        }
        this.updated = true;
    }

    public String getRevision() {
        return this.revision;
    }

    public synchronized String calAndGetRevision() {
        if (this.revision != null && !this.updated) {
            return this.revision;
        }
        this.updated = false;
        if (CollectionUtils.isEmptyMap(this.services)) {
            this.revision = "0";
        } else {
            String tempRevision = this.calRevision();
            if (!StringUtils.isEquals((String)this.revision, (String)tempRevision)) {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("metadata revision changed: %s -> %s, app: %s, services: %d", this.revision, tempRevision, this.app, this.services.size()));
                }
                this.revision = tempRevision;
                this.rawMetadataInfo = JsonUtils.toJson((Object)this);
            }
        }
        return this.revision;
    }

    public synchronized String calRevision() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.app);
        for (Map.Entry<String, ServiceInfo> entry : new TreeMap<String, ServiceInfo>(this.services).entrySet()) {
            sb.append(entry.getValue().toDescString());
        }
        return RevisionResolver.calRevision(sb.toString());
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    @Transient
    public String getContent() {
        return this.rawMetadataInfo;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public Map<String, ServiceInfo> getServices() {
        return this.services;
    }

    public ServiceInfo getServiceInfo(String protocolServiceKey) {
        return this.services.get(protocolServiceKey);
    }

    public ServiceInfo getNoProtocolServiceInfo(String serviceKeyWithoutProtocol) {
        if (CollectionUtils.isEmptyMap(this.subscribedServices)) {
            return null;
        }
        Set<ServiceInfo> subServices = this.subscribedServices.get(serviceKeyWithoutProtocol);
        if (CollectionUtils.isNotEmpty(subServices)) {
            List validServices = subServices.stream().filter(serviceInfo -> StringUtils.isEmpty((String)serviceInfo.getParameter("isExtra"))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(validServices)) {
                return (ServiceInfo)validServices.iterator().next();
            }
            return subServices.iterator().next();
        }
        return null;
    }

    public ServiceInfo getValidServiceInfo(String serviceKey) {
        ServiceInfo serviceInfo = this.getServiceInfo(serviceKey);
        if (serviceInfo == null && (serviceInfo = this.getNoProtocolServiceInfo(serviceKey)) == null) {
            return null;
        }
        return serviceInfo;
    }

    public List<ServiceInfo> getMatchedServiceInfos(ProtocolServiceKey consumerProtocolServiceKey) {
        return this.getServices().values().stream().filter(serviceInfo -> serviceInfo.matchProtocolServiceKey(consumerProtocolServiceKey)).collect(Collectors.toList());
    }

    public Map<String, String> getExtendParams() {
        return this.extendParams;
    }

    public Map<String, String> getInstanceParams() {
        return this.instanceParams;
    }

    public String getParameter(String key, String serviceKey) {
        ServiceInfo serviceInfo = this.getValidServiceInfo(serviceKey);
        if (serviceInfo == null) {
            return null;
        }
        return serviceInfo.getParameter(key);
    }

    public Map<String, String> getParameters(String serviceKey) {
        ServiceInfo serviceInfo = this.getValidServiceInfo(serviceKey);
        if (serviceInfo == null) {
            return Collections.emptyMap();
        }
        return serviceInfo.getAllParams();
    }

    public String getServiceString(String protocolServiceKey) {
        if (protocolServiceKey == null) {
            return null;
        }
        ServiceInfo serviceInfo = this.getValidServiceInfo(protocolServiceKey);
        if (serviceInfo == null) {
            return null;
        }
        return serviceInfo.toFullString();
    }

    public synchronized void addSubscribedURL(URL url) {
        if (this.subscribedServiceURLs == null) {
            this.subscribedServiceURLs = new ConcurrentSkipListMap<String, SortedSet<URL>>();
        }
        this.addURL(this.subscribedServiceURLs, url);
    }

    public boolean removeSubscribedURL(URL url) {
        if (this.subscribedServiceURLs == null) {
            return true;
        }
        return this.removeURL(this.subscribedServiceURLs, url);
    }

    public ConcurrentNavigableMap<String, SortedSet<URL>> getSubscribedServiceURLs() {
        return this.subscribedServiceURLs;
    }

    public ConcurrentNavigableMap<String, SortedSet<URL>> getExportedServiceURLs() {
        return this.exportedServiceURLs;
    }

    public Set<URL> collectExportedURLSet() {
        if (this.exportedServiceURLs == null) {
            return Collections.emptySet();
        }
        return this.exportedServiceURLs.values().stream().filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private boolean addURL(Map<String, SortedSet<URL>> serviceURLs, URL url) {
        SortedSet urls = serviceURLs.computeIfAbsent(url.getServiceKey(), this::newSortedURLs);
        return urls.add(url);
    }

    boolean removeURL(Map<String, SortedSet<URL>> serviceURLs, URL url) {
        String key = url.getServiceKey();
        SortedSet urls = serviceURLs.getOrDefault(key, null);
        if (urls == null) {
            return true;
        }
        boolean r = urls.remove(url);
        if (urls.isEmpty()) {
            serviceURLs.remove(key);
        }
        return r;
    }

    private SortedSet<URL> newSortedURLs(String serviceKey) {
        return new TreeSet<URL>(URLComparator.INSTANCE);
    }

    public int hashCode() {
        return Objects.hash(this.app, this.services);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MetadataInfo)) {
            return false;
        }
        MetadataInfo other = (MetadataInfo)obj;
        return Objects.equals(this.app, other.getApp()) && (this.services == null && other.services == null || this.services != null && this.services.equals(other.services));
    }

    private void extractInstanceParams(URL url, List<MetadataParamsFilter> filters) {
        Object[] excluded;
        Object[] included;
        if (CollectionUtils.isEmpty(filters)) {
            return;
        }
        if (filters.size() == 1) {
            MetadataParamsFilter filter2 = filters.get(0);
            included = filter2.instanceParamsIncluded();
            excluded = filter2.instanceParamsExcluded();
        } else {
            HashSet includedList = new HashSet();
            HashSet excludedList = new HashSet();
            filters.forEach(filter -> {
                if (ArrayUtils.isNotEmpty((Object[])filter.instanceParamsIncluded())) {
                    includedList.addAll(Arrays.asList(filter.instanceParamsIncluded()));
                }
                if (ArrayUtils.isNotEmpty((Object[])filter.instanceParamsExcluded())) {
                    excludedList.addAll(Arrays.asList(filter.instanceParamsExcluded()));
                }
            });
            included = includedList.toArray(new String[0]);
            excluded = excludedList.toArray(new String[0]);
        }
        HashMap<Object, String> tmpInstanceParams = new HashMap<Object, String>();
        if (ArrayUtils.isNotEmpty((Object[])included)) {
            for (Object p : included) {
                String value2 = url.getParameter((String)p);
                if (value2 == null) continue;
                tmpInstanceParams.put(p, value2);
            }
        } else if (ArrayUtils.isNotEmpty((Object[])excluded)) {
            tmpInstanceParams.putAll(url.getParameters());
            for (Object p : excluded) {
                tmpInstanceParams.remove(p);
            }
        }
        tmpInstanceParams.forEach((key, value) -> {
            String oldValue = this.instanceParams.put((String)key, (String)value);
            if (!"timestamp".equals(key) && oldValue != null && !oldValue.equals(value)) {
                throw new IllegalStateException(String.format("Inconsistent instance metadata found in different services: %s, %s", oldValue, value));
            }
        });
    }

    public String toString() {
        return "metadata{app='" + this.app + "',revision='" + this.revision + "',size=" + (this.services == null ? 0 : this.services.size()) + ",services=" + this.getSimplifiedServices(this.services) + "}";
    }

    public String toFullString() {
        return "metadata{app='" + this.app + "',revision='" + this.revision + "',services=" + this.services + "}";
    }

    private String getSimplifiedServices(Map<String, ServiceInfo> services) {
        if (services == null) {
            return "[]";
        }
        return services.keySet().toString();
    }

    public synchronized MetadataInfo clone() {
        return new MetadataInfo(this.app, this.revision, this.services, this.initiated, this.extendParams, this.instanceParams, this.updated, this.subscribedServiceURLs, this.exportedServiceURLs, this.loader);
    }

    private Object readResolve() {
        return new MetadataInfo(this.app, this.revision, this.services);
    }

    public static class ServiceInfo
    implements Serializable {
        private String name;
        private String group;
        private String version;
        private String protocol;
        private int port = -1;
        private String path;
        private Map<String, String> params;
        private volatile transient Map<String, String> consumerParams;
        private volatile transient Map<String, Map<String, String>> methodParams;
        private volatile transient Map<String, Map<String, String>> consumerMethodParams;
        private volatile transient Map<String, Number> numbers;
        private volatile transient Map<String, Map<String, Number>> methodNumbers;
        private volatile transient String serviceKey;
        private volatile transient String matchKey;
        private volatile transient ProtocolServiceKey protocolServiceKey;
        private transient URL url;

        public ServiceInfo() {
        }

        public ServiceInfo(URL url, List<MetadataParamsFilter> filters) {
            this(url.getServiceInterface(), url.getGroup(), url.getVersion(), url.getProtocol(), url.getPort(), url.getPath(), null);
            this.url = url;
            Map<String, String> params = this.extractServiceParams(url, filters);
            this.methodParams = URLParam.initMethodParameters(params);
            this.consumerMethodParams = URLParam.initMethodParameters(this.consumerParams);
        }

        public ServiceInfo(String name, String group, String version, String protocol, int port, String path, Map<String, String> params) {
            this.name = name;
            this.group = group;
            this.version = version;
            this.protocol = protocol;
            this.port = port;
            this.path = path;
            this.params = params == null ? new ConcurrentHashMap() : params;
            this.serviceKey = this.buildServiceKey(name, group, version);
            this.matchKey = this.buildMatchKey();
        }

        private Map<String, String> extractServiceParams(URL url, List<MetadataParamsFilter> filters) {
            Object[] excluded;
            Object[] included;
            HashMap<String, String> params = new HashMap<String, String>();
            if (CollectionUtils.isEmpty(filters)) {
                params.putAll(url.getParameters());
                this.params = params;
                return params;
            }
            if (filters.size() == 1) {
                included = filters.get(0).serviceParamsIncluded();
                excluded = filters.get(0).serviceParamsExcluded();
            } else {
                HashSet<String> includedList = new HashSet<String>();
                Object[] excludedList = new HashSet();
                for (MetadataParamsFilter filter : filters) {
                    if (ArrayUtils.isNotEmpty((Object[])filter.serviceParamsIncluded())) {
                        includedList.addAll(Arrays.asList(filter.serviceParamsIncluded()));
                    }
                    if (!ArrayUtils.isNotEmpty((Object[])filter.serviceParamsExcluded())) continue;
                    excludedList.addAll(Arrays.asList(filter.serviceParamsExcluded()));
                }
                included = includedList.toArray(new String[0]);
                excluded = excludedList.toArray(new String[0]);
            }
            if (ArrayUtils.isNotEmpty((Object[])included)) {
                String[] methods = url.getParameter("methods", (String[])null);
                for (Object p : included) {
                    String value = url.getParameter((String)p);
                    if (StringUtils.isNotEmpty((String)value) && params.get(p) == null) {
                        params.put((String)p, value);
                    }
                    this.appendMethodParams(url, params, methods, (String)p);
                }
            } else if (ArrayUtils.isNotEmpty((Object[])excluded)) {
                for (Map.Entry entry : url.getParameters().entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    boolean shouldAdd = true;
                    for (Object excludeKey : excluded) {
                        if (!key.equalsIgnoreCase((String)excludeKey) && !key.contains("." + (String)excludeKey)) continue;
                        shouldAdd = false;
                        break;
                    }
                    if (!shouldAdd) continue;
                    params.put(key, value);
                }
            }
            this.params = params;
            return params;
        }

        private void appendMethodParams(URL url, Map<String, String> params, String[] methods, String p) {
            if (methods != null) {
                for (String method : methods) {
                    String mValue = url.getMethodParameterStrict(method, p);
                    if (!StringUtils.isNotEmpty((String)mValue)) continue;
                    params.put(method + "." + p, mValue);
                }
            }
        }

        protected void init() {
            this.buildMatchKey();
            this.buildServiceKey(this.name, this.group, this.version);
            this.methodParams = URLParam.initMethodParameters(this.params);
        }

        public String getMatchKey() {
            if (this.matchKey != null) {
                return this.matchKey;
            }
            this.buildMatchKey();
            return this.matchKey;
        }

        private String buildMatchKey() {
            this.matchKey = this.getServiceKey();
            if (StringUtils.isNotEmpty((String)this.protocol)) {
                this.matchKey = this.getServiceKey() + ":" + this.protocol;
            }
            return this.matchKey;
        }

        public boolean matchProtocolServiceKey(ProtocolServiceKey protocolServiceKey) {
            return ProtocolServiceKey.Matcher.isMatch((ProtocolServiceKey)protocolServiceKey, (ProtocolServiceKey)this.getProtocolServiceKey());
        }

        public ProtocolServiceKey getProtocolServiceKey() {
            if (this.protocolServiceKey != null) {
                return this.protocolServiceKey;
            }
            this.protocolServiceKey = new ProtocolServiceKey(this.name, this.version, this.group, this.protocol);
            return this.protocolServiceKey;
        }

        private String buildServiceKey(String name, String group, String version) {
            this.serviceKey = URL.buildKey((String)name, (String)group, (String)version);
            return this.serviceKey;
        }

        public String getServiceKey() {
            if (this.serviceKey != null) {
                return this.serviceKey;
            }
            this.buildServiceKey(this.name, this.group, this.version);
            return this.serviceKey;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public Map<String, String> getParams() {
            if (this.params == null) {
                return Collections.emptyMap();
            }
            return this.params;
        }

        public void setParams(Map<String, String> params) {
            this.params = params;
        }

        @Transient
        public Map<String, String> getAllParams() {
            if (this.consumerParams != null) {
                HashMap<String, String> allParams = new HashMap<String, String>((int)((float)(this.params.size() + this.consumerParams.size()) / 0.75f + 1.0f));
                allParams.putAll(this.params);
                allParams.putAll(this.consumerParams);
                return allParams;
            }
            return this.params;
        }

        public String getParameter(String key) {
            String value;
            if (this.consumerParams != null && (value = this.consumerParams.get(key)) != null) {
                return value;
            }
            return this.params.get(key);
        }

        public String getMethodParameter(String method, String key, String defaultValue) {
            String value = this.getMethodParameter(method, key, this.consumerMethodParams);
            if (value != null) {
                return value;
            }
            value = this.getMethodParameter(method, key, this.methodParams);
            return value == null ? defaultValue : value;
        }

        private String getMethodParameter(String method, String key, Map<String, Map<String, String>> map) {
            String value = null;
            if (map == null) {
                return value;
            }
            Map<String, String> keyMap = map.get(method);
            if (keyMap != null) {
                value = keyMap.get(key);
            }
            return value;
        }

        public boolean hasMethodParameter(String method, String key) {
            String value = this.getMethodParameter(method, key, (String)null);
            return StringUtils.isNotEmpty((String)value);
        }

        public boolean hasMethodParameter(String method) {
            return this.consumerMethodParams != null && this.consumerMethodParams.containsKey(method) || this.methodParams != null && this.methodParams.containsKey(method);
        }

        public String toDescString() {
            return this.getMatchKey() + this.port + this.path + new TreeMap<String, String>(this.getParams());
        }

        public void addParameter(String key, String value) {
            if (this.consumerParams != null) {
                this.consumerParams.put(key, value);
            }
            this.consumerMethodParams = URLParam.initMethodParameters(this.consumerParams);
        }

        public void addParameterIfAbsent(String key, String value) {
            if (this.consumerParams != null) {
                this.consumerParams.putIfAbsent(key, value);
            }
            this.consumerMethodParams = URLParam.initMethodParameters(this.consumerParams);
        }

        public void addConsumerParams(Map<String, String> params) {
            if (this.consumerParams == null) {
                this.consumerParams = new ConcurrentHashMap<String, String>(params);
                this.consumerMethodParams = URLParam.initMethodParameters(this.consumerParams);
            }
        }

        public Map<String, Number> getNumbers() {
            if (this.numbers == null) {
                this.numbers = new ConcurrentHashMap<String, Number>();
            }
            return this.numbers;
        }

        public Map<String, Map<String, Number>> getMethodNumbers() {
            if (this.methodNumbers == null) {
                this.methodNumbers = new ConcurrentHashMap<String, Map<String, Number>>();
            }
            return this.methodNumbers;
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ServiceInfo)) {
                return false;
            }
            ServiceInfo serviceInfo = (ServiceInfo)obj;
            return Objects.equals(this.getVersion(), serviceInfo.getVersion()) && Objects.equals(this.getGroup(), serviceInfo.getGroup()) && Objects.equals(this.getName(), serviceInfo.getName()) && Objects.equals(this.getProtocol(), serviceInfo.getProtocol()) && Objects.equals(this.getPort(), serviceInfo.getPort()) && this.getParams().equals(serviceInfo.getParams());
        }

        public int hashCode() {
            return Objects.hash(this.getVersion(), this.getGroup(), this.getName(), this.getProtocol(), this.getPort(), this.getParams());
        }

        public String toString() {
            return this.getMatchKey();
        }

        public String toFullString() {
            return "service{name='" + this.name + "',group='" + this.group + "',version='" + this.version + "',protocol='" + this.protocol + "',port='" + this.port + "',params=" + this.params + ",}";
        }
    }

    static class URLComparator
    implements Comparator<URL> {
        public static final URLComparator INSTANCE = new URLComparator();

        URLComparator() {
        }

        @Override
        public int compare(URL o1, URL o2) {
            return o1.toFullString().compareTo(o2.toFullString());
        }
    }
}

