/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.maven.plugin.aot;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.SystemPropertyConfigUtils;

public class JavaExecutable {
    private final File file;

    public JavaExecutable() {
        String javaHome = SystemPropertyConfigUtils.getSystemProperty((String)"java.home");
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)javaHome), (String)"Unable to find java executable due to missing 'java.home'");
        this.file = this.findInJavaHome(javaHome);
    }

    private File findInJavaHome(String javaHome) {
        File bin = new File(new File(javaHome), "bin");
        File command = new File(bin, "java.exe");
        command = command.exists() ? command : new File(bin, "java");
        Assert.assertTrue((boolean)command.exists(), () -> "Unable to find java in " + javaHome);
        return command;
    }

    public ProcessBuilder processBuilder(String ... arguments) {
        ProcessBuilder processBuilder = new ProcessBuilder(this.toString());
        processBuilder.command().addAll(Arrays.asList(arguments));
        return processBuilder;
    }

    public String toString() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

