/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.nested;

import java.io.Serializable;
import org.apache.dubbo.config.nested.Http3Config;
import org.apache.dubbo.config.nested.RestConfig;
import org.apache.dubbo.config.nested.ServletConfig;
import org.apache.dubbo.config.nested.WebSocketConfig;
import org.apache.dubbo.config.support.Nested;
import org.apache.dubbo.config.support.Parameter;

public class TripleConfig
implements Serializable {
    private static final long serialVersionUID = -3682252713701362155L;
    public static final int DEFAULT_MAX_BODY_SIZE = 0x800000;
    public static final int DEFAULT_MAX_RESPONSE_BODY_SIZE = 0x800000;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 0x800000;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 16384;
    public static final int DEFAULT_HEADER_TABLE_SIZE = 4096;
    public static final boolean DEFAULT_ENABLE_PUSH = false;
    public static final int DEFAULT_MAX_CONCURRENT_STREAMS = Integer.MAX_VALUE;
    public static final int DEFAULT_INITIAL_WINDOW_SIZE = 0x800000;
    public static final int DEFAULT_CONNECTION_INITIAL_WINDOW_SIZE_KEY = 65536;
    public static final int DEFAULT_MAX_FRAME_SIZE = 0x800000;
    public static final int DEFAULT_MAX_HEADER_LIST_SIZE = 32768;
    private Boolean verbose;
    private Integer maxBodySize;
    private Integer maxResponseBodySize;
    private Integer maxChunkSize;
    private Integer maxHeaderSize;
    private Integer maxInitialLineLength;
    private Integer initialBufferSize;
    private Integer headerTableSize;
    private Boolean enablePush;
    private Integer maxConcurrentStreams;
    private Integer initialWindowSize;
    private Integer connectionInitialWindowSize;
    private Integer maxFrameSize;
    private Integer maxHeaderListSize;
    @Nested
    private RestConfig rest;
    @Nested
    private Http3Config http3;
    @Nested
    private ServletConfig servlet;
    @Nested
    private WebSocketConfig websocket;

    public Boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    public Integer getMaxBodySize() {
        return this.maxBodySize;
    }

    @Parameter(excluded=true)
    public int getMaxBodySizeOrDefault() {
        return this.maxBodySize == null ? 0x800000 : this.maxBodySize;
    }

    public void setMaxBodySize(Integer maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    public Integer getMaxResponseBodySize() {
        return this.maxResponseBodySize;
    }

    @Parameter(excluded=true)
    public int getMaxResponseBodySizeOrDefault() {
        return this.maxResponseBodySize == null ? 0x800000 : this.maxResponseBodySize;
    }

    public void setMaxResponseBodySize(Integer maxResponseBodySize) {
        this.maxResponseBodySize = maxResponseBodySize;
    }

    public Integer getMaxChunkSize() {
        return this.maxChunkSize;
    }

    @Parameter(excluded=true)
    public int getMaxChunkSizeOrDefault() {
        return this.maxChunkSize == null ? 0x800000 : this.maxChunkSize;
    }

    public void setMaxChunkSize(Integer maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public Integer getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    @Parameter(excluded=true)
    public int getMaxHeaderSizeOrDefault() {
        return this.maxHeaderSize == null ? 8192 : this.maxHeaderSize;
    }

    public void setMaxHeaderSize(Integer maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
    }

    public Integer getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    @Parameter(excluded=true)
    public int getMaxInitialLineLengthOrDefault() {
        return this.maxInitialLineLength == null ? 4096 : this.maxInitialLineLength;
    }

    public void setMaxInitialLineLength(Integer maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
    }

    public Integer getInitialBufferSize() {
        return this.initialBufferSize;
    }

    @Parameter(excluded=true)
    public int getInitialBufferSizeOrDefault() {
        return this.initialBufferSize == null ? 16384 : this.initialBufferSize;
    }

    public void setInitialBufferSize(Integer initialBufferSize) {
        this.initialBufferSize = initialBufferSize;
    }

    public Integer getHeaderTableSize() {
        return this.headerTableSize;
    }

    @Parameter(excluded=true)
    public int getHeaderTableSizeOrDefault() {
        return this.headerTableSize == null ? 4096 : this.headerTableSize;
    }

    public void setHeaderTableSize(Integer headerTableSize) {
        this.headerTableSize = headerTableSize;
    }

    public Boolean getEnablePush() {
        return this.enablePush;
    }

    @Parameter(excluded=true)
    public boolean getEnablePushOrDefault() {
        return this.enablePush == null ? false : this.enablePush;
    }

    public void setEnablePush(Boolean enablePush) {
        this.enablePush = enablePush;
    }

    public Integer getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    @Parameter(excluded=true)
    public int getMaxConcurrentStreamsOrDefault() {
        return this.maxConcurrentStreams == null ? Integer.MAX_VALUE : this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(Integer maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public Integer getInitialWindowSize() {
        return this.initialWindowSize;
    }

    @Parameter(excluded=true)
    public int getInitialWindowSizeOrDefault() {
        return this.initialWindowSize == null ? 0x800000 : this.initialWindowSize;
    }

    public void setInitialWindowSize(Integer initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public Integer getConnectionInitialWindowSize() {
        return this.connectionInitialWindowSize;
    }

    @Parameter(excluded=true)
    public Integer getConnectionInitialWindowSizeOrDefault() {
        return this.connectionInitialWindowSize == null ? 65536 : this.connectionInitialWindowSize;
    }

    public void setConnectionInitialWindowSize(Integer connectionInitialWindowSize) {
        this.connectionInitialWindowSize = connectionInitialWindowSize;
    }

    public Integer getMaxFrameSize() {
        return this.maxFrameSize;
    }

    @Parameter(excluded=true)
    public int getMaxFrameSizeOrDefault() {
        return this.maxFrameSize == null ? 0x800000 : this.maxFrameSize;
    }

    public void setMaxFrameSize(Integer maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public Integer getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    @Parameter(excluded=true)
    public int getMaxHeaderListSizeOrDefault() {
        return this.maxHeaderListSize == null ? 32768 : this.maxHeaderListSize;
    }

    public void setMaxHeaderListSize(Integer maxHeaderListSize) {
        this.maxHeaderListSize = maxHeaderListSize;
    }

    public RestConfig getRest() {
        return this.rest;
    }

    @Parameter(excluded=true)
    public RestConfig getRestOrDefault() {
        if (this.rest == null) {
            this.rest = new RestConfig();
        }
        return this.rest;
    }

    public void setRest(RestConfig rest) {
        this.rest = rest;
    }

    public Http3Config getHttp3() {
        return this.http3;
    }

    @Parameter(excluded=true)
    public Http3Config getHttp3OrDefault() {
        if (this.http3 == null) {
            this.http3 = new Http3Config();
        }
        return this.http3;
    }

    public void setHttp3(Http3Config http3) {
        this.http3 = http3;
    }

    public ServletConfig getServlet() {
        return this.servlet;
    }

    public void setServlet(ServletConfig servlet) {
        this.servlet = servlet;
    }

    public WebSocketConfig getWebsocket() {
        return this.websocket;
    }

    public void setWebsocket(WebSocketConfig websocket) {
        this.websocket = websocket;
    }
}

