/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.logger.log4j2;

import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.support.FailsafeLogger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class Log4j2Logger
implements Logger {
    private final String fqcn;
    private final ExtendedLogger logger;

    public Log4j2Logger(ExtendedLogger logger) {
        this.fqcn = FailsafeLogger.class.getName();
        this.logger = logger;
    }

    public Log4j2Logger(String fqcn, ExtendedLogger logger) {
        this.fqcn = fqcn;
        this.logger = logger;
    }

    @Override
    public void trace(String msg) {
        this.logger.logIfEnabled(this.fqcn, Level.TRACE, null, msg);
    }

    @Override
    public void trace(String msg, Object ... arguments) {
        this.logger.logIfEnabled(this.fqcn, Level.TRACE, null, msg, arguments);
    }

    @Override
    public void trace(Throwable e) {
        this.logger.logIfEnabled(this.fqcn, Level.TRACE, null, e == null ? null : e.getMessage(), e);
    }

    @Override
    public void trace(String msg, Throwable e) {
        this.logger.logIfEnabled(this.fqcn, Level.TRACE, null, msg, e);
    }

    @Override
    public void debug(String msg) {
        this.logger.logIfEnabled(this.fqcn, Level.DEBUG, null, msg);
    }

    @Override
    public void debug(String msg, Object ... arguments) {
        this.logger.logIfEnabled(this.fqcn, Level.DEBUG, null, msg, arguments);
    }

    @Override
    public void debug(Throwable e) {
        this.logger.logIfEnabled(this.fqcn, Level.DEBUG, null, e == null ? null : e.getMessage(), e);
    }

    @Override
    public void debug(String msg, Throwable e) {
        this.logger.logIfEnabled(this.fqcn, Level.DEBUG, null, msg, e);
    }

    @Override
    public void info(String msg) {
        this.logger.logIfEnabled(this.fqcn, Level.INFO, null, msg);
    }

    @Override
    public void info(String msg, Object ... arguments) {
        this.logger.logIfEnabled(this.fqcn, Level.INFO, null, msg, arguments);
    }

    @Override
    public void info(Throwable e) {
        this.logger.logIfEnabled(this.fqcn, Level.INFO, null, e == null ? null : e.getMessage(), e);
    }

    @Override
    public void info(String msg, Throwable e) {
        this.logger.logIfEnabled(this.fqcn, Level.INFO, null, msg, e);
    }

    @Override
    public void warn(String msg) {
        this.logger.logIfEnabled(this.fqcn, Level.WARN, null, msg);
    }

    @Override
    public void warn(String msg, Object ... arguments) {
        this.logger.logIfEnabled(this.fqcn, Level.WARN, null, msg, arguments);
    }

    @Override
    public void warn(Throwable e) {
        this.logger.logIfEnabled(this.fqcn, Level.WARN, null, e == null ? null : e.getMessage(), e);
    }

    @Override
    public void warn(String msg, Throwable e) {
        this.logger.logIfEnabled(this.fqcn, Level.WARN, null, msg, e);
    }

    @Override
    public void error(String msg) {
        this.logger.logIfEnabled(this.fqcn, Level.ERROR, null, msg);
    }

    @Override
    public void error(String msg, Object ... arguments) {
        this.logger.logIfEnabled(this.fqcn, Level.ERROR, null, msg, arguments);
    }

    @Override
    public void error(Throwable e) {
        this.logger.logIfEnabled(this.fqcn, Level.ERROR, null, e == null ? null : e.getMessage(), e);
    }

    @Override
    public void error(String msg, Throwable e) {
        this.logger.logIfEnabled(this.fqcn, Level.ERROR, null, msg, e);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public org.apache.logging.log4j.Logger getLogger() {
        return this.logger;
    }
}

