/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.util.Map;
import java.util.Properties;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.rpc.model.ScopeModel;

public class PropertiesConfiguration
implements Configuration {
    private Properties properties;
    private final ScopeModel scopeModel;

    public PropertiesConfiguration(ScopeModel scopeModel) {
        this.scopeModel = scopeModel;
        this.refresh();
    }

    public void refresh() {
        this.properties = ConfigUtils.getProperties(this.scopeModel.getClassLoaders());
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public Object getInternalProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String remove(String key) {
        return (String)this.properties.remove(key);
    }

    @Deprecated
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

