/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.utils.CollectionUtils;

public final class Pair<L, R>
implements Map.Entry<L, R>,
Comparable<Pair<L, R>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pair NULL = new Pair<Object, Object>(null, null);
    private final L left;
    private final R right;

    public static <L, R> Pair<L, R> of(L left, R right) {
        return left == null && right == null ? Pair.nullPair() : new Pair<L, R>(left, right);
    }

    public static <L, R> Pair<L, R> nullPair() {
        return NULL;
    }

    @SafeVarargs
    public static <L, R> Map<L, R> toMap(Pair<L, R> ... pairs) {
        if (pairs == null) {
            return Collections.emptyMap();
        }
        return Pair.toMap(Arrays.asList(pairs));
    }

    public static <L, R> Map<L, R> toMap(Collection<Pair<L, R>> pairs) {
        if (pairs == null) {
            return Collections.emptyMap();
        }
        Map map = CollectionUtils.newLinkedHashMap(pairs.size());
        for (Pair<L, R> pair : pairs) {
            map.put(pair.getLeft(), pair.getRight());
        }
        return map;
    }

    public static <L, R> List<Pair<L, R>> toPairs(Map<L, R> map) {
        if (map == null) {
            return Collections.emptyList();
        }
        ArrayList<Pair<L, R>> pairs = new ArrayList<Pair<L, R>>(map.size());
        for (Map.Entry<L, R> entry : map.entrySet()) {
            pairs.add(Pair.of(entry.getKey(), entry.getValue()));
        }
        return pairs;
    }

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public boolean isNull() {
        return this == NULL || this.left == null && this.right == null;
    }

    @Override
    public L getKey() {
        return this.left;
    }

    @Override
    public R getValue() {
        return this.right;
    }

    @Override
    public R setValue(R value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Pair<L, R> other) {
        return this.left.equals(other.left) ? ((Comparable)this.right).compareTo(other.right) : ((Comparable)this.left).compareTo(other.left);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.left) ^ Objects.hashCode(this.right);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)other;
            return Objects.equals(this.left, that.getKey()) && Objects.equals(this.right, that.getValue());
        }
        return false;
    }

    public String toString() {
        return "(" + this.left + ", " + this.right + ')';
    }
}

