/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.io.OutputStream;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.SystemPropertyConfigUtils;

public class JVMUtil {
    public static void jstack(OutputStream stream) throws Exception {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadMxBean.dumpAllThreads(true, true)) {
            stream.write(JVMUtil.getThreadDumpString(threadInfo).getBytes());
        }
    }

    private static String getThreadDumpString(ThreadInfo threadInfo) {
        LockInfo[] locks;
        StringBuilder sb = new StringBuilder("\"" + threadInfo.getThreadName() + "\" Id=" + threadInfo.getThreadId() + " " + (Object)((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null) {
            sb.append(" on " + threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by \"" + threadInfo.getLockOwnerName() + "\" Id=" + threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        int i = 0;
        int jstackMaxLine = 32;
        String jstackMaxLineStr = SystemPropertyConfigUtils.getSystemProperty("dubbo.jstack-dump.max-line");
        if (StringUtils.isNotEmpty(jstackMaxLineStr)) {
            try {
                jstackMaxLine = Integer.parseInt(jstackMaxLineStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StackTraceElement[] stackTrace = threadInfo.getStackTrace();
        MonitorInfo[] lockedMonitors = threadInfo.getLockedMonitors();
        while (i < stackTrace.length && i < jstackMaxLine) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                Thread.State ts = threadInfo.getThreadState();
                if (Thread.State.BLOCKED.equals((Object)ts)) {
                    sb.append("\t-  blocked on ").append(threadInfo.getLockInfo());
                    sb.append('\n');
                } else if (Thread.State.WAITING.equals((Object)ts) || Thread.State.TIMED_WAITING.equals((Object)ts)) {
                    sb.append("\t-  waiting on ").append(threadInfo.getLockInfo());
                    sb.append('\n');
                }
            }
            for (LockInfo lockInfo : lockedMonitors) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ").append(lockInfo);
                sb.append('\n');
            }
            ++i;
        }
        if (i < stackTrace.length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = threadInfo.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- " + lockInfo);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

