/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.reference;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;

public abstract class ReferenceCountedResource
implements AutoCloseable {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ReferenceCountedResource.class);
    private static final AtomicLongFieldUpdater<ReferenceCountedResource> COUNTER_UPDATER = AtomicLongFieldUpdater.newUpdater(ReferenceCountedResource.class, "counter");
    private volatile long counter = 1L;

    public final ReferenceCountedResource retain() {
        long oldCount = COUNTER_UPDATER.getAndIncrement(this);
        if (oldCount <= 0L) {
            COUNTER_UPDATER.getAndDecrement(this);
            throw new AssertionError((Object)"This instance has been destroyed");
        }
        return this;
    }

    public final boolean release() {
        long remainingCount = COUNTER_UPDATER.decrementAndGet(this);
        if (remainingCount == 0L) {
            this.destroy();
            return true;
        }
        if (remainingCount <= -1L) {
            logger.warn("4-7", "", "", "This instance has been destroyed");
            return false;
        }
        return false;
    }

    @Override
    public final void close() {
        this.release();
    }

    protected abstract void destroy();
}

