/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.logger.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.ListenableLogger;
import org.apache.dubbo.common.logger.LogListener;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.support.FailsafeLogger;
import org.apache.dubbo.common.utils.NetUtils;

public class FailsafeErrorTypeAwareLogger
extends FailsafeLogger
implements ListenableLogger {
    private static final String INSTRUCTIONS_URL = "https://dubbo.apache.org/faq/%d/%d";
    private static final Pattern ERROR_CODE_PATTERN = Pattern.compile("\\d+-\\d+");
    private static final List<LogListener> GLOBAL_LISTENERS = Collections.synchronizedList(new ArrayList());
    private final AtomicReference<List<LogListener>> listeners = new AtomicReference();

    public FailsafeErrorTypeAwareLogger(Logger logger) {
        super(logger);
    }

    private String appendContextMessageWithInstructions(String code, String cause, String extendedInformation, String msg) {
        return " [DUBBO] " + msg + ", dubbo version: " + Version.getVersion() + ", current host: " + NetUtils.getLocalHost() + ", error code: " + code + ". This may be caused by " + cause + ", go to " + this.getErrorUrl(code) + " to find instructions. " + extendedInformation;
    }

    private String getErrorUrl(String code) {
        String trimmedString = code.trim();
        if (!ERROR_CODE_PATTERN.matcher(trimmedString).matches()) {
            this.error("Invalid error code: " + code + ", the format of error code is: X-X (where X is a number).");
            return "";
        }
        String[] segments = trimmedString.split("[-]");
        int[] errorCodeSegments = new int[2];
        try {
            errorCodeSegments[0] = Integer.parseInt(segments[0]);
            errorCodeSegments[1] = Integer.parseInt(segments[1]);
        }
        catch (NumberFormatException numberFormatException) {
            this.error("Invalid error code: " + code + ", the format of error code is: X-X (where X is a number).", numberFormatException);
            return "";
        }
        return String.format(INSTRUCTIONS_URL, errorCodeSegments[0], errorCodeSegments[1]);
    }

    @Override
    public void warn(String code, String cause, String extendedInformation, String msg) {
        if (FailsafeErrorTypeAwareLogger.getDisabled()) {
            return;
        }
        try {
            this.onEvent(code, msg);
            if (!this.getLogger().isWarnEnabled()) {
                return;
            }
            this.getLogger().warn(this.appendContextMessageWithInstructions(code, cause, extendedInformation, msg));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void warn(String code, String cause, String extendedInformation, String msg, Throwable e) {
        if (FailsafeErrorTypeAwareLogger.getDisabled()) {
            return;
        }
        try {
            this.onEvent(code, msg);
            if (!this.getLogger().isWarnEnabled()) {
                return;
            }
            this.getLogger().warn(this.appendContextMessageWithInstructions(code, cause, extendedInformation, msg), e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void error(String code, String cause, String extendedInformation, String msg) {
        if (FailsafeErrorTypeAwareLogger.getDisabled()) {
            return;
        }
        try {
            this.onEvent(code, msg);
            if (!this.getLogger().isErrorEnabled()) {
                return;
            }
            this.getLogger().error(this.appendContextMessageWithInstructions(code, cause, extendedInformation, msg));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void error(String code, String cause, String extendedInformation, String msg, Throwable e) {
        if (FailsafeErrorTypeAwareLogger.getDisabled()) {
            return;
        }
        try {
            this.onEvent(code, msg);
            if (!this.getLogger().isErrorEnabled()) {
                return;
            }
            this.getLogger().error(this.appendContextMessageWithInstructions(code, cause, extendedInformation, msg), e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void registerGlobalListen(LogListener listener) {
        GLOBAL_LISTENERS.add(listener);
    }

    @Override
    public void registerListen(LogListener listener) {
        this.listeners.getAndUpdate(logListeners -> {
            if (logListeners == null) {
                logListeners = Collections.synchronizedList(new ArrayList());
            }
            logListeners.add(listener);
            return logListeners;
        });
    }

    private void onEvent(String code, String msg) {
        Optional.ofNullable(this.listeners.get()).ifPresent(logListeners -> logListeners.forEach(logListener -> {
            try {
                logListener.onMessage(code, msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        GLOBAL_LISTENERS.forEach(logListener -> {
            try {
                logListener.onMessage(code, msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

