/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.json.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.json.impl.AbstractJsonUtilImpl;

@Activate(order=300, onClass={"com.google.gson.Gson"})
public class GsonImpl
extends AbstractJsonUtilImpl {
    private volatile Gson gson;

    @Override
    public String getName() {
        return "gson";
    }

    @Override
    public boolean isJson(String json) {
        try {
            JsonElement jsonElement = JsonParser.parseString((String)json);
            return jsonElement.isJsonObject() || jsonElement.isJsonArray();
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }

    @Override
    public <T> T toJavaObject(String json, Type type) {
        return (T)this.getGson().fromJson(json, type);
    }

    @Override
    public <T> List<T> toJavaList(String json, Class<T> clazz) {
        Type type = TypeToken.getParameterized(List.class, (Type[])new Type[]{clazz}).getType();
        return (List)this.getGson().fromJson(json, type);
    }

    @Override
    public String toJson(Object obj) {
        return this.getGson().toJson(obj);
    }

    @Override
    public String toPrettyJson(Object obj) {
        return this.createBuilder().setPrettyPrinting().create().toJson(obj);
    }

    @Override
    public Object convertObject(Object obj, Type type) {
        Gson gson = this.getGson();
        return gson.fromJson(gson.toJsonTree(obj), type);
    }

    @Override
    public Object convertObject(Object obj, Class<?> clazz) {
        Gson gson = this.getGson();
        return gson.fromJson(gson.toJsonTree(obj), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Gson getGson() {
        Gson gson = this.gson;
        if (gson == null) {
            GsonImpl gsonImpl = this;
            synchronized (gsonImpl) {
                gson = this.gson;
                if (gson == null) {
                    this.gson = gson = this.createBuilder().create();
                }
            }
        }
        return gson;
    }

    protected GsonBuilder createBuilder() {
        return new GsonBuilder();
    }
}

