/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.cluster.ConfiguratorFactory;

public interface Configurator
extends Comparable<Configurator> {
    public URL getUrl();

    public URL configure(URL var1);

    public static Optional<List<Configurator>> toConfigurators(List<URL> urls) {
        if (CollectionUtils.isEmpty(urls)) {
            return Optional.empty();
        }
        ConfiguratorFactory configuratorFactory = (ConfiguratorFactory)urls.get(0).getOrDefaultApplicationModel().getExtensionLoader(ConfiguratorFactory.class).getAdaptiveExtension();
        ArrayList<Configurator> configurators = new ArrayList<Configurator>(urls.size());
        for (URL url : urls) {
            if ("empty".equals(url.getProtocol())) {
                configurators.clear();
                break;
            }
            HashMap override = new HashMap(url.getParameters());
            override.remove("anyhost");
            if (CollectionUtils.isEmptyMap(override)) continue;
            configurators.add(configuratorFactory.getConfigurator(url));
        }
        Collections.sort(configurators);
        return Optional.of(configurators);
    }

    @Override
    default public int compareTo(Configurator o) {
        if (o == null) {
            return -1;
        }
        int ipCompare = this.getUrl().getHost().compareTo(o.getUrl().getHost());
        if (ipCompare == 0) {
            int i = this.getUrl().getParameter("priority", 0);
            int j = o.getUrl().getParameter("priority", 0);
            return Integer.compare(i, j);
        }
        return ipCompare;
    }
}

