/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.tracing.tracer;

import org.apache.dubbo.config.TracingConfig;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.tracing.tracer.TracerProvider;
import org.apache.dubbo.tracing.tracer.brave.BraveProvider;
import org.apache.dubbo.tracing.tracer.otel.OpenTelemetryProvider;
import org.apache.dubbo.tracing.utils.ObservationSupportUtil;

public class TracerProviderFactory {
    public static TracerProvider getProvider(ApplicationModel applicationModel, TracingConfig tracingConfig) {
        if (ObservationSupportUtil.isSupportOTelTracer()) {
            return new OpenTelemetryProvider(applicationModel, tracingConfig);
        }
        if (ObservationSupportUtil.isSupportBraveTracer()) {
            return new BraveProvider(applicationModel, tracingConfig);
        }
        return null;
    }
}

