/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.tracing.filter;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;
import org.apache.dubbo.tracing.DefaultDubboClientObservationConvention;
import org.apache.dubbo.tracing.DubboClientObservationConvention;
import org.apache.dubbo.tracing.DubboObservationDocumentation;
import org.apache.dubbo.tracing.context.DubboClientContext;

@Activate(group={"consumer"}, order=-2147483598, onClass={"io.micrometer.observation.NoopObservationRegistry"})
public class ObservationSenderFilter
implements ClusterFilter,
BaseFilter.Listener,
ScopeModelAware {
    private final ObservationRegistry observationRegistry;
    private final DubboClientObservationConvention clientObservationConvention;

    public ObservationSenderFilter(ApplicationModel applicationModel) {
        this.observationRegistry = applicationModel.getBeanFactory().getBean(ObservationRegistry.class);
        this.clientObservationConvention = applicationModel.getBeanFactory().getBean(DubboClientObservationConvention.class);
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (this.observationRegistry == null) {
            return invoker.invoke(invocation);
        }
        DubboClientContext senderContext = new DubboClientContext(invoker, invocation);
        Observation observation = DubboObservationDocumentation.CLIENT.observation(this.clientObservationConvention, DefaultDubboClientObservationConvention.getInstance(), () -> senderContext, this.observationRegistry);
        invocation.put(Observation.class, observation.start());
        return (Result)observation.scoped(() -> invoker.invoke(invocation));
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        Observation observation = this.getObservation(invocation);
        if (observation == null) {
            return;
        }
        if (appResponse != null && appResponse.hasException()) {
            observation.error(appResponse.getException());
        }
        observation.stop();
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        Observation observation = this.getObservation(invocation);
        if (observation == null) {
            return;
        }
        observation.error(t);
        observation.stop();
    }

    private Observation getObservation(Invocation invocation) {
        return (Observation)invocation.get(Observation.class);
    }
}

