/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.tracing;

import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.DefaultTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingReceiverTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingSenderTracingObservationHandler;
import io.micrometer.tracing.propagation.Propagator;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.config.TracingConfig;
import org.apache.dubbo.metrics.utils.MetricsSupportUtil;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.tracing.handler.DubboClientTracingObservationHandler;
import org.apache.dubbo.tracing.handler.DubboServerTracingObservationHandler;
import org.apache.dubbo.tracing.metrics.ObservationMeter;
import org.apache.dubbo.tracing.tracer.PropagatorProvider;
import org.apache.dubbo.tracing.tracer.PropagatorProviderFactory;
import org.apache.dubbo.tracing.tracer.TracerProvider;
import org.apache.dubbo.tracing.tracer.TracerProviderFactory;

public class DubboObservationRegistry {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DubboObservationRegistry.class);
    private final ApplicationModel applicationModel;
    private final TracingConfig tracingConfig;

    public DubboObservationRegistry(ApplicationModel applicationModel, TracingConfig tracingConfig) {
        this.applicationModel = applicationModel;
        this.tracingConfig = tracingConfig;
    }

    public void initObservationRegistry() {
        TracerProvider tracerProvider;
        ObservationRegistry externalObservationRegistry = this.applicationModel.getBeanFactory().getBean(ObservationRegistry.class);
        if (externalObservationRegistry != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("ObservationRegistry.class from external is existed.");
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Tracing config is: " + JsonUtils.toJson(this.tracingConfig));
        }
        if ((tracerProvider = TracerProviderFactory.getProvider(this.applicationModel, this.tracingConfig)) == null) {
            logger.warn("0-29", "", "", "Can not found OpenTelemetry/Brave tracer dependencies, skip init ObservationRegistry.");
            return;
        }
        Tracer tracer = tracerProvider.getTracer();
        PropagatorProvider propagatorProvider = PropagatorProviderFactory.getPropagatorProvider();
        Propagator propagator = propagatorProvider != null ? propagatorProvider.getPropagator() : Propagator.NOOP;
        ObservationRegistry registry = ObservationRegistry.create();
        registry.observationConfig().observationHandler((ObservationHandler)new ObservationHandler.FirstMatchingCompositeObservationHandler(new ObservationHandler[]{new PropagatingSenderTracingObservationHandler(tracer, propagator), new PropagatingReceiverTracingObservationHandler(tracer, propagator), new DefaultTracingObservationHandler(tracer)})).observationHandler((ObservationHandler)new ObservationHandler.FirstMatchingCompositeObservationHandler(new ObservationHandler[]{new DubboClientTracingObservationHandler(tracer), new DubboServerTracingObservationHandler(tracer)}));
        if (MetricsSupportUtil.isSupportMetrics()) {
            ObservationMeter.addMeterRegistry(registry, this.applicationModel);
        }
        this.applicationModel.getBeanFactory().registerBean(registry);
        this.applicationModel.getBeanFactory().registerBean(tracer);
        this.applicationModel.getBeanFactory().registerBean(propagator);
    }
}

