/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.tracing;

import io.micrometer.common.KeyValues;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcContextAttachment;
import org.apache.dubbo.tracing.AbstractDefaultDubboObservationConvention;
import org.apache.dubbo.tracing.DubboClientObservationConvention;
import org.apache.dubbo.tracing.DubboObservationDocumentation;
import org.apache.dubbo.tracing.context.DubboClientContext;

public class DefaultDubboClientObservationConvention
extends AbstractDefaultDubboObservationConvention
implements DubboClientObservationConvention {
    private static final DubboClientObservationConvention INSTANCE = new DefaultDubboClientObservationConvention();

    public static DubboClientObservationConvention getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return "rpc.client.duration";
    }

    public KeyValues getLowCardinalityKeyValues(DubboClientContext context) {
        KeyValues keyValues = super.getLowCardinalityKeyValues(context.getInvocation());
        return this.withRemoteHostPort(keyValues, context);
    }

    private KeyValues withRemoteHostPort(KeyValues keyValues, DubboClientContext context) {
        List<Invoker<?>> invokedInvokers = context.getInvocation().getInvokedInvokers();
        if (invokedInvokers.isEmpty()) {
            return keyValues;
        }
        Invoker<?> invoker = invokedInvokers.get(0);
        URL url = invoker.getUrl();
        RpcContextAttachment rpcContextAttachment = RpcContext.getClientAttachment();
        String remoteHost = this.remoteHost(rpcContextAttachment, url);
        int remotePort = this.remotePort(rpcContextAttachment, url);
        return this.withRemoteHostPort(keyValues, remoteHost, remotePort);
    }

    private String remoteHost(RpcContextAttachment rpcContextAttachment, URL url) {
        String remoteHost = url != null ? url.getHost() : null;
        return remoteHost != null ? remoteHost : rpcContextAttachment.getRemoteHost();
    }

    private int remotePort(RpcContextAttachment rpcContextAttachment, URL url) {
        Integer remotePort;
        Integer n = remotePort = url != null ? Integer.valueOf(url.getPort()) : null;
        if (remotePort != null) {
            return remotePort;
        }
        return rpcContextAttachment.getRemotePort() != 0 ? rpcContextAttachment.getRemotePort() : rpcContextAttachment.getLocalPort();
    }

    private KeyValues withRemoteHostPort(KeyValues keyValues, String remoteHostName, int remotePort) {
        keyValues = this.appendNonNull(keyValues, DubboObservationDocumentation.LowCardinalityKeyNames.NET_PEER_NAME, remoteHostName);
        if (remotePort == 0) {
            return keyValues;
        }
        return this.appendNonNull(keyValues, DubboObservationDocumentation.LowCardinalityKeyNames.NET_PEER_PORT, String.valueOf(remotePort));
    }

    public String getContextualName(DubboClientContext context) {
        return super.getContextualName(context.getInvocation());
    }
}

