/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.websocket.jakarta;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.rpc.protocol.tri.websocket.jakarta.TripleEndpoint;

public class TripleWebSocketFilter
implements Filter {
    private static final ErrorTypeAwareLogger LOG = LoggerFactory.getErrorTypeAwareLogger(TripleWebSocketFilter.class);
    private transient ServerContainer sc;
    private final Set<String> existed = new ConcurrentHashSet<String>();

    public void init(FilterConfig filterConfig) {
        this.sc = (ServerContainer)filterConfig.getServletContext().getAttribute(ServerContainer.class.getName());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.isWebSocketUpgradeRequest(request, response)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest hRequest = (HttpServletRequest)request;
        HttpServletResponse hResponse = (HttpServletResponse)response;
        String pathInfo = hRequest.getPathInfo();
        String path = pathInfo == null ? hRequest.getServletPath() : hRequest.getServletPath() + pathInfo;
        final HashMap<String, String[]> copiedMap = new HashMap<String, String[]>(hRequest.getParameterMap());
        copiedMap.put("tri.websocket.remote.address", new String[]{hRequest.getRemoteHost(), String.valueOf(hRequest.getRemotePort())});
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(hRequest){

            public Map<String, String[]> getParameterMap() {
                return copiedMap;
            }
        };
        if (this.existed.contains(path)) {
            chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)hResponse);
            return;
        }
        ServerEndpointConfig serverEndpointConfig = ServerEndpointConfig.Builder.create(TripleEndpoint.class, (String)path).build();
        try {
            this.sc.addEndpoint(serverEndpointConfig);
            this.existed.add(path);
        }
        catch (Exception e) {
            LOG.error("4-11", "", "", "Failed to add endpoint", e);
            hResponse.sendError(400);
            return;
        }
        chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)hResponse);
    }

    public void destroy() {
    }

    public boolean isWebSocketUpgradeRequest(ServletRequest request, ServletResponse response) {
        return request instanceof HttpServletRequest && response instanceof HttpServletResponse && this.headerContainsToken((HttpServletRequest)request, "Upgrade", "websocket") && HttpMethods.GET.name().equals(((HttpServletRequest)request).getMethod());
    }

    private boolean headerContainsToken(HttpServletRequest req, String headerName, String target) {
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                if (!target.equalsIgnoreCase(token.trim())) continue;
                return true;
            }
        }
        return false;
    }
}

