/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.BatchExecutorQueue;
import org.apache.dubbo.netty.shaded.io.netty.channel.Channel;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFuture;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPromise;
import org.apache.dubbo.rpc.protocol.tri.command.QueuedCommand;

public class TripleWriteQueue
extends BatchExecutorQueue<QueuedCommand> {
    public TripleWriteQueue() {
    }

    public TripleWriteQueue(int chunkSize) {
        super(chunkSize);
    }

    public ChannelFuture enqueue(QueuedCommand command, boolean rst) {
        return this.enqueue(command);
    }

    public ChannelFuture enqueue(QueuedCommand command) {
        return this.enqueueFuture(command, command.channel().eventLoop());
    }

    public ChannelFuture enqueueFuture(QueuedCommand command, Executor executor) {
        ChannelPromise promise = command.promise();
        if (promise == null) {
            Channel ch = command.channel();
            promise = ch.newPromise();
            command.promise(promise);
        }
        super.enqueue(command, executor);
        return promise;
    }

    @Override
    protected void prepare(QueuedCommand item) {
        try {
            Channel channel = item.channel();
            item.run(channel);
        }
        catch (CompletionException e) {
            item.promise().tryFailure(e.getCause());
        }
    }

    @Override
    protected void flush(QueuedCommand item) {
        try {
            Channel channel = item.channel();
            item.run(channel);
            channel.flush();
        }
        catch (CompletionException e) {
            item.promise().tryFailure(e.getCause());
        }
    }
}

