/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import java.io.IOException;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPromise;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2ChannelDuplexHandler;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2GoAwayFrame;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2PingFrame;
import org.apache.dubbo.netty.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.dubbo.rpc.protocol.tri.transport.GracefulShutdown;

public class TripleServerConnectionHandler
extends Http2ChannelDuplexHandler {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(TripleServerConnectionHandler.class);
    private static final Set<String> QUIET_EXCEPTIONS = new HashSet<String>();
    private static final Set<Class<?>> QUIET_EXCEPTIONS_CLASS = new HashSet();
    private GracefulShutdown gracefulShutdown;

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2PingFrame) {
            if (((Http2PingFrame)msg).content() == 40715087873L) {
                if (this.gracefulShutdown == null) {
                    logger.warn("4-14", "", "", "Received GRACEFUL_SHUTDOWN_PING Ack but gracefulShutdown is null");
                } else {
                    this.gracefulShutdown.secondGoAwayAndClose(ctx);
                }
            }
        } else if (msg instanceof Http2GoAwayFrame) {
            ReferenceCountUtil.release(msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.forEachActiveStream(stream -> {
            if (!stream.state().remoteSideOpen()) {
                return true;
            }
            DefaultHttp2ResetFrame resetFrame = new DefaultHttp2ResetFrame(Http2Error.NO_ERROR).stream(stream);
            ctx.fireChannelRead(resetFrame);
            return true;
        });
    }

    private boolean isQuiteException(Throwable t) {
        if (QUIET_EXCEPTIONS_CLASS.contains(t.getClass())) {
            return true;
        }
        return QUIET_EXCEPTIONS.contains(t.getClass().getSimpleName());
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.isQuiteException(cause)) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Channel:%s Error", ctx.channel()), cause);
            }
        } else {
            logger.warn("4-14", "", "", String.format("Channel:%s Error", ctx.channel()), cause);
        }
        ctx.close();
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (this.gracefulShutdown == null) {
            this.gracefulShutdown = new GracefulShutdown(ctx, "app_requested", promise);
        }
        this.gracefulShutdown.gracefulShutdown();
    }

    static {
        QUIET_EXCEPTIONS.add("NativeIoException");
        QUIET_EXCEPTIONS_CLASS.add(IOException.class);
        QUIET_EXCEPTIONS_CLASS.add(SocketException.class);
    }
}

