/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2DataFrame;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2GoAwayFrame;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2HeadersFrame;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2ResetFrame;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2StreamFrame;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.transport.H2TransportListener;

public final class TripleHttp2ClientResponseHandler
extends SimpleChannelInboundHandler<Http2StreamFrame> {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(TripleHttp2ClientResponseHandler.class);
    private final H2TransportListener transportListener;

    public TripleHttp2ClientResponseHandler(H2TransportListener listener) {
        super(false);
        this.transportListener = listener;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        if (evt instanceof Http2GoAwayFrame) {
            Http2GoAwayFrame event = (Http2GoAwayFrame)evt;
            ctx.close();
            LOGGER.debug("Event triggered, event name is: " + event.name() + ", last stream id is: " + event.lastStreamId());
        } else if (evt instanceof Http2ResetFrame) {
            this.onResetRead(ctx, (Http2ResetFrame)evt);
        }
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Http2StreamFrame msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame headers = (Http2HeadersFrame)msg;
            this.transportListener.onHeader(headers.headers(), headers.isEndStream());
        } else if (msg instanceof Http2DataFrame) {
            Http2DataFrame data = (Http2DataFrame)msg;
            this.transportListener.onData(data.content(), data.isEndStream());
        } else {
            super.channelRead(ctx, msg);
        }
    }

    private void onResetRead(ChannelHandlerContext ctx, Http2ResetFrame resetFrame) {
        LOGGER.warn("4-10", "", "", "Triple Client received remote reset errorCode=" + resetFrame.errorCode());
        this.transportListener.cancelByRemote(resetFrame.errorCode());
        ctx.close();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.transportListener.onClose();
        ctx.close();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        TriRpcStatus status = TriRpcStatus.INTERNAL.withCause(cause);
        LOGGER.warn("4-10", "", "", "Meet Exception on ClientResponseHandler, status code is: " + (Object)((Object)status.code), cause);
        this.transportListener.cancelByRemote(Http2Error.INTERNAL_ERROR.code());
        ctx.close();
    }
}

