/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelDuplexHandler;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2GoAwayFrame;
import org.apache.dubbo.netty.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.dubbo.remoting.api.connection.ConnectionHandler;

public class TripleGoAwayHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(TripleGoAwayHandler.class);

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2GoAwayFrame) {
            ConnectionHandler connectionHandler = (ConnectionHandler)((Object)ctx.pipeline().get("connectionHandler"));
            if (logger.isInfoEnabled()) {
                logger.info("Receive go away frame of " + ctx.channel().localAddress() + " -> " + ctx.channel().remoteAddress() + " and will reconnect later.");
            }
            connectionHandler.onGoAway(ctx.channel());
            ReferenceCountUtil.release(msg);
            return;
        }
        super.channelRead(ctx, msg);
    }
}

