/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import java.util.concurrent.TimeUnit;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBufUtil;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPromise;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2PingFrame;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2Error;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.Future;

public class GracefulShutdown {
    static final long GRACEFUL_SHUTDOWN_PING = 40715087873L;
    private static final long GRACEFUL_SHUTDOWN_PING_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(10L);
    private final ChannelHandlerContext ctx;
    private final ChannelPromise originPromise;
    private final String goAwayMessage;
    private boolean pingAckedOrTimeout;
    private Future<?> pingFuture;

    public GracefulShutdown(ChannelHandlerContext ctx, String goAwayMessage, ChannelPromise originPromise) {
        this.ctx = ctx;
        this.goAwayMessage = goAwayMessage;
        this.originPromise = originPromise;
    }

    public void gracefulShutdown() {
        DefaultHttp2GoAwayFrame goAwayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR, ByteBufUtil.writeAscii(this.ctx.alloc(), (CharSequence)this.goAwayMessage));
        goAwayFrame.setExtraStreamIds(Integer.MAX_VALUE);
        this.ctx.writeAndFlush(goAwayFrame);
        this.pingFuture = this.ctx.executor().schedule(() -> this.secondGoAwayAndClose(this.ctx), GRACEFUL_SHUTDOWN_PING_TIMEOUT_NANOS, TimeUnit.NANOSECONDS);
        DefaultHttp2PingFrame pingFrame = new DefaultHttp2PingFrame(40715087873L, false);
        this.ctx.writeAndFlush(pingFrame);
    }

    void secondGoAwayAndClose(ChannelHandlerContext ctx) {
        if (this.pingAckedOrTimeout) {
            return;
        }
        this.pingAckedOrTimeout = true;
        this.pingFuture.cancel(false);
        try {
            DefaultHttp2GoAwayFrame goAwayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR, ByteBufUtil.writeAscii(this.ctx.alloc(), (CharSequence)this.goAwayMessage));
            ctx.writeAndFlush(goAwayFrame);
            ctx.close(this.originPromise);
        }
        catch (Exception e) {
            ctx.fireExceptionCaught(e);
        }
    }
}

