/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.servlet;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessageFrame;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

final class ServletStreamChannel
implements H2StreamChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletStreamChannel.class);
    private final Queue<Object> writeQueue = new ConcurrentLinkedQueue<Object>();
    private final AtomicBoolean writeable = new AtomicBoolean();
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final AsyncContext context;
    private boolean isGrpc;

    ServletStreamChannel(HttpServletRequest request, HttpServletResponse response, AsyncContext context) {
        this.request = request;
        this.response = response;
        this.context = context;
    }

    public void setGrpc(boolean isGrpc) {
        this.isGrpc = isGrpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeError(int code, Throwable throwable) {
        block9: {
            if (this.response.isCommitted() && code == TriRpcStatus.Code.DEADLINE_EXCEEDED.code) {
                return;
            }
            try {
                if (this.isGrpc) {
                    this.response.setTrailerFields(() -> {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(TripleHeaderEnum.STATUS_KEY.getName(), String.valueOf(code));
                        return map;
                    });
                    return;
                }
                try {
                    if (throwable instanceof HttpStatusException) {
                        this.response.setStatus(((HttpStatusException)throwable).getStatusCode());
                        this.response.getOutputStream().close();
                        break block9;
                    }
                    this.response.sendError(500);
                }
                catch (Throwable t) {
                    LOGGER.info("Failed to send response", t);
                }
            }
            finally {
                this.context.complete();
            }
        }
    }

    public void onWritePossible() {
        if (this.writeable.compareAndSet(false, true)) {
            this.flushQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushQueue() {
        if (this.writeQueue.isEmpty()) {
            return;
        }
        Queue<Object> queue = this.writeQueue;
        synchronized (queue) {
            Object obj;
            while ((obj = this.writeQueue.poll()) != null) {
                if (obj instanceof HttpMetadata) {
                    this.writeHeaderInternal((HttpMetadata)obj);
                    continue;
                }
                if (!(obj instanceof HttpOutputMessage)) continue;
                this.writeMessageInternal((HttpOutputMessage)obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> writeResetFrame(long errorCode) {
        if (this.isGrpc) {
            this.writeError(TriRpcStatus.httpStatusToGrpcCode((int)((int)errorCode)).code, null);
            return ServletStreamChannel.completed();
        }
        try {
            if (errorCode == 0L) {
                this.response.getOutputStream().close();
                CompletableFuture<Void> completableFuture = ServletStreamChannel.completed();
                return completableFuture;
            }
            if (this.response.isCommitted()) {
                CompletableFuture<Void> completableFuture = ServletStreamChannel.completed();
                return completableFuture;
            }
            if (errorCode >= 300L && errorCode < 600L) {
                this.response.sendError((int)errorCode);
            } else {
                this.response.sendError(500);
            }
        }
        catch (Throwable t) {
            LOGGER.info("Failed to close response", t);
        }
        finally {
            this.context.complete();
        }
        return ServletStreamChannel.completed();
    }

    @Override
    public Http2OutputMessage newOutputMessage(boolean endStream) {
        return new Http2OutputMessageFrame(new ByteArrayOutputStream(256), endStream);
    }

    @Override
    public CompletableFuture<Void> writeHeader(HttpMetadata httpMetadata) {
        if (this.writeable.get()) {
            this.flushQueue();
            this.writeHeaderInternal(httpMetadata);
        } else {
            this.writeQueue.add(httpMetadata);
        }
        return ServletStreamChannel.completed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeaderInternal(HttpMetadata httpMetadata) {
        boolean endStream = false;
        boolean isHttp1 = true;
        if (httpMetadata instanceof Http2Header) {
            endStream = ((Http2Header)httpMetadata).isEndStream();
            isHttp1 = false;
        }
        try {
            HttpHeaders headers = httpMetadata.headers();
            if (endStream) {
                this.response.setTrailerFields(() -> {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (Map.Entry<CharSequence, String> entry : headers) {
                        map.put(entry.getKey().toString(), entry.getValue());
                    }
                    return map;
                });
                return;
            }
            if (this.response.isCommitted()) {
                return;
            }
            for (Map.Entry<CharSequence, String> entry : headers) {
                String key = entry.getKey().toString();
                String value = entry.getValue();
                if (HttpHeaderNames.STATUS.getName().equals(key)) {
                    this.response.setStatus(Integer.parseInt(value));
                    continue;
                }
                if (isHttp1 && HttpHeaderNames.TRANSFER_ENCODING.getName().equals(key) && "chunked".equals(value)) continue;
                this.response.addHeader(key, value);
            }
        }
        catch (Throwable t) {
            LOGGER.info("Failed to write header", t);
        }
        finally {
            if (endStream) {
                this.context.complete();
            }
        }
    }

    @Override
    public CompletableFuture<Void> writeMessage(HttpOutputMessage httpOutputMessage) {
        if (this.writeable.get()) {
            this.flushQueue();
            this.writeMessageInternal(httpOutputMessage);
        } else {
            this.writeQueue.add(httpOutputMessage);
        }
        return ServletStreamChannel.completed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessageInternal(HttpOutputMessage httpOutputMessage) {
        boolean endStream = false;
        if (httpOutputMessage instanceof Http2OutputMessage) {
            endStream = ((Http2OutputMessage)httpOutputMessage).isEndStream();
        } else if (httpOutputMessage == HttpOutputMessage.EMPTY_MESSAGE) {
            endStream = true;
        }
        try {
            ByteArrayOutputStream bos = (ByteArrayOutputStream)httpOutputMessage.getBody();
            ServletOutputStream out = this.response.getOutputStream();
            bos.writeTo((OutputStream)out);
            out.flush();
        }
        catch (Throwable t) {
            LOGGER.info("Failed to write message", t);
        }
        finally {
            if (endStream) {
                this.context.complete();
            }
        }
    }

    @Override
    public SocketAddress remoteAddress() {
        return InetSocketAddress.createUnresolved(this.request.getRemoteAddr(), this.request.getRemotePort());
    }

    @Override
    public SocketAddress localAddress() {
        return InetSocketAddress.createUnresolved(this.request.getLocalAddr(), this.request.getLocalPort());
    }

    @Override
    public void flush() {
    }

    private static CompletableFuture<Void> completed() {
        return CompletableFuture.completedFuture(null);
    }
}

