/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.servlet;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.h2.Http2Header;

public final class HttpMetadataAdapter
implements Http2Header {
    private final HttpServletRequest request;
    private HttpHeaders headers;

    HttpMetadataAdapter(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpHeaders headers() {
        HttpHeaders headers = this.headers;
        if (headers == null) {
            headers = HttpHeaders.create();
            Enumeration en = this.request.getHeaderNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Enumeration ven = this.request.getHeaders(key);
                while (ven.hasMoreElements()) {
                    headers.add((CharSequence)key, (String)ven.nextElement());
                }
            }
            headers.add((CharSequence)Http2Headers.PseudoHeaderName.METHOD.value(), this.method());
            headers.add((CharSequence)Http2Headers.PseudoHeaderName.SCHEME.value(), this.request.getScheme());
            headers.add((CharSequence)Http2Headers.PseudoHeaderName.AUTHORITY.value(), this.request.getServerName());
            headers.add((CharSequence)Http2Headers.PseudoHeaderName.PROTOCOL.value(), this.request.getProtocol());
            this.headers = headers;
        }
        return headers;
    }

    @Override
    public String method() {
        return this.request.getMethod();
    }

    @Override
    public String path() {
        String query = this.request.getQueryString();
        return query == null ? this.request.getRequestURI() : this.request.getRequestURI() + '?' + query;
    }

    @Override
    public long id() {
        return -1L;
    }

    @Override
    public boolean isEndStream() {
        return false;
    }
}

