/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.route;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.RequestMetadata;
import org.apache.dubbo.remoting.http12.message.HttpMessageAdapterFactory;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.RpcInvocationBuildContext;
import org.apache.dubbo.rpc.protocol.tri.route.RequestHandler;
import org.apache.dubbo.rpc.protocol.tri.route.RequestHandlerMapping;
import org.apache.dubbo.rpc.protocol.tri.route.RequestRouter;

public final class DefaultRequestRouter
implements RequestRouter {
    private final HttpMessageAdapterFactory<HttpRequest, HttpMetadata, Void> httpMessageAdapterFactory;
    private final List<RequestHandlerMapping> requestHandlerMappings;

    public DefaultRequestRouter(FrameworkModel frameworkModel) {
        this.httpMessageAdapterFactory = frameworkModel.getFirstActivateExtension(HttpMessageAdapterFactory.class);
        this.requestHandlerMappings = frameworkModel.getActivateExtensions(RequestHandlerMapping.class);
    }

    @Override
    public RpcInvocationBuildContext route(URL url, RequestMetadata metadata, HttpChannel httpChannel) {
        HttpRequest request = this.httpMessageAdapterFactory.adaptRequest(metadata, httpChannel);
        HttpResponse response = this.httpMessageAdapterFactory.adaptResponse(request, metadata);
        int size = this.requestHandlerMappings.size();
        for (int i = 0; i < size; ++i) {
            RequestHandlerMapping mapping = this.requestHandlerMappings.get(i);
            RequestHandler handler = mapping.getRequestHandler(url, request, response);
            if (handler == null) continue;
            handler.setAttribute("tri.handler.type", mapping.getType());
            handler.setAttribute("tri.http.request", request);
            handler.setAttribute("tri.http.response", response);
            return handler;
        }
        return null;
    }
}

