/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.util;

import java.nio.charset.StandardCharsets;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.MathUtil;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.PlatformDependent;

public final class KeyString
implements CharSequence {
    public static final KeyString EMPTY = new KeyString("");
    private final byte[] value;
    private final int offset;
    private final int length;
    private final boolean caseSensitive;
    private int hash;

    public KeyString(CharSequence value) {
        this(value, false);
    }

    public KeyString(CharSequence value, boolean caseSensitive) {
        this.value = KeyString.toBytes(value);
        this.offset = 0;
        this.length = this.value.length;
        this.caseSensitive = caseSensitive;
    }

    private KeyString(byte[] value, int start, int end, boolean caseSensitive) {
        this.value = value;
        this.offset = start;
        this.length = end - start;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("index: " + index + " must be in the range [0," + this.length + ")");
        }
        return (char)(PlatformDependent.getByte(this.value, index + this.offset) & 0xFF);
    }

    public byte[] array() {
        return this.value;
    }

    public int offset() {
        return this.offset;
    }

    public KeyString subSequence(int start) {
        return this.subSequence(start, this.length);
    }

    @Override
    public KeyString subSequence(int start, int end) {
        int len = this.length;
        if (end < 0) {
            end = len;
        }
        if (MathUtil.isOutOfBounds(start, end - start, len)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= end (" + end + ") <= len(" + len + ')');
        }
        if (start == 0 && end == len) {
            return this;
        }
        if (end == start) {
            return EMPTY;
        }
        return new KeyString(this.value, start + this.offset, end + this.offset, this.caseSensitive);
    }

    public int indexOf(char ch, int start) {
        if (ch < '\u0100') {
            if (start < 0) {
                start = 0;
            }
            byte b = (byte)ch;
            byte[] value = this.value;
            int offset = this.offset;
            int len = this.length + offset;
            for (int i = start + offset; i < len; ++i) {
                if (value[i] != b) continue;
                return i - offset;
            }
        }
        return -1;
    }

    public int lastIndexOf(char ch, int start) {
        if (ch < '\u0100') {
            if (start < 0 || start >= this.length) {
                start = this.length - 1;
            }
            byte b = (byte)ch;
            byte[] value = this.value;
            int offset = this.offset;
            for (int i = offset + start; i >= offset; --i) {
                if (value[i] != b) continue;
                return i - offset;
            }
        }
        return -1;
    }

    public boolean regionMatches(int start, KeyString other) {
        return this.regionMatches(start, other, 0, other.length());
    }

    public boolean regionMatches(int start, KeyString other, int otherStart, int length) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        if (otherStart < 0 || length > other.length() - otherStart) {
            return false;
        }
        if (start < 0 || length > this.length() - start) {
            return false;
        }
        if (this.caseSensitive) {
            return PlatformDependent.equals(this.value, this.offset, other.value, other.offset, length);
        }
        byte[] value = this.value;
        byte[] otherValue = other.value;
        int i = start + this.offset;
        int j = otherStart + other.offset;
        int end = i + length;
        while (i < end) {
            byte a = value[i];
            byte b = otherValue[j];
            if (a != b && KeyString.toLowerCase(a) != KeyString.toLowerCase(b)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = PlatformDependent.hashCodeAscii(this.value, this.offset, this.length);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != KeyString.class) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        KeyString other = (KeyString)obj;
        int len = this.length;
        if (len != other.length) {
            return false;
        }
        if (this.caseSensitive) {
            return PlatformDependent.equals(this.value, this.offset, other.value, other.offset, len);
        }
        byte[] value = this.value;
        byte[] otherValue = other.value;
        int i = this.offset;
        int j = other.offset;
        int end = i + len;
        while (i < end) {
            byte a = value[i];
            byte b = otherValue[j];
            if (a != b && KeyString.toLowerCase(a) != KeyString.toLowerCase(b)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.toString(0, this.length);
    }

    public String toString(int start) {
        return this.toString(start, this.length);
    }

    public String toString(int start, int end) {
        int count;
        int len = this.length;
        if (end == -1) {
            end = len;
        }
        if ((count = end - start) == 0) {
            return "";
        }
        if (MathUtil.isOutOfBounds(start, count, len)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= srcIdx + count(" + count + ") <= srcLen(" + len + ')');
        }
        return new String(this.value, 0, start + this.offset, count);
    }

    private static byte[] toBytes(CharSequence value) {
        if (value.getClass() == String.class) {
            return ((String)value).getBytes(StandardCharsets.ISO_8859_1);
        }
        int len = value.length();
        byte[] array = PlatformDependent.allocateUninitializedArray(len);
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            array[i] = (byte)(c > '\u00ff' ? 63 : (int)c);
        }
        return array;
    }

    private static byte toLowerCase(byte value) {
        return value >= 65 && value <= 90 ? (byte)(value + 32) : value;
    }
}

