/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.swagger;

import java.io.IOException;
import java.io.InputStream;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.webjars.WebJarVersionLocator;

public class WebjarHelper {
    public static final boolean ENABLED = ClassUtils.isPresent("org.webjars.WebJarVersionLocator");
    private static volatile WebjarHelper INSTANCE;
    private final WebJarVersionLocator locator = new WebJarVersionLocator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebjarHelper getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<WebjarHelper> clazz = WebjarHelper.class;
        synchronized (WebjarHelper.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new WebjarHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public HttpResult<?> handleAssets(String webjar, String path) {
        try {
            byte[] bytes = this.getWebjarResource(webjar, path);
            if (bytes != null) {
                return HttpResult.builder().header("Cache-Control", "public, max-age=604800").body(bytes).build();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new HttpStatusException(HttpStatus.NOT_FOUND.getCode());
    }

    public boolean hasWebjar(String webjar) {
        return this.locator.version(webjar) != null;
    }

    private byte[] getWebjarResource(String webjar, String exactPath) throws IOException {
        InputStream is;
        String fullPath = this.locator.fullPath(webjar, exactPath);
        if (fullPath != null && (is = WebJarVersionLocator.class.getClassLoader().getResourceAsStream(fullPath)) != null) {
            return StreamUtils.readBytes(is);
        }
        return null;
    }
}

