/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.jakarta;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpUtils;
import org.apache.dubbo.remoting.http12.message.DefaultHttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.support.servlet.jakarta.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;

public class ServletHttpResponseAdapter
extends DefaultHttpResponse
implements HttpServletResponse {
    private ServletOutputStream sos;
    private PrintWriter writer;

    public void addCookie(Cookie cookie) {
        this.addCookie(Helper.convert(cookie));
    }

    public boolean containsHeader(String name) {
        return this.hasHeader(name);
    }

    public String encodeURL(String url) {
        return RequestUtils.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return RequestUtils.encodeURL(url);
    }

    public String encodeUrl(String url) {
        return RequestUtils.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return RequestUtils.encodeURL(url);
    }

    public void sendRedirect(String location, int sc, boolean clearBuffer) {
        this.sendRedirect(location);
    }

    public void setDateHeader(String name, long date) {
        this.setHeader((CharSequence)name, new Date(date));
    }

    public void addDateHeader(String name, long date) {
        this.addHeader((CharSequence)name, new Date(date));
    }

    public void setHeader(String name, String value) {
        super.setHeader((CharSequence)name, value);
    }

    public void addHeader(String name, String value) {
        super.addHeader((CharSequence)name, value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    public void setStatus(int sc, String sm) {
        this.setStatus(sc);
        this.setBody(sm);
    }

    public int getStatus() {
        return this.status();
    }

    public String getHeader(String name) {
        return this.header(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.headerValues(name);
    }

    public Collection<String> getHeaderNames() {
        return this.headerNames();
    }

    public String getCharacterEncoding() {
        return this.charset();
    }

    public String getContentType() {
        return this.contentType();
    }

    public ServletOutputStream getOutputStream() {
        if (this.sos == null) {
            this.sos = new HttpOutputStream(this.outputStream());
        }
        return this.sos;
    }

    public PrintWriter getWriter() {
        if (this.writer == null) {
            String ce = this.getCharacterEncoding();
            Charset charset = ce == null ? StandardCharsets.UTF_8 : Charset.forName(ce);
            this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream(), charset), true);
        }
        return this.writer;
    }

    public void setCharacterEncoding(String charset) {
        this.setCharset(charset);
    }

    public void setContentLength(int len) {
    }

    public void setContentLengthLong(long len) {
    }

    public void setBufferSize(int size) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
        OutputStream os = this.outputStream();
        if (os instanceof BufferedOutputStream) {
            os.flush();
        }
    }

    public void setLocale(Locale loc) {
        this.setLocale(loc.toLanguageTag());
    }

    public Locale getLocale() {
        Locale locale = CollectionUtils.first(HttpUtils.parseContentLanguage(this.locale()));
        return locale == null ? Locale.getDefault() : locale;
    }

    @Override
    public String toString() {
        return "ServletHttpResponseAdapter{" + this.fieldToString() + '}';
    }

    private static final class HttpOutputStream
    extends ServletOutputStream {
        private final OutputStream outputStream;

        private HttpOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.outputStream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.outputStream.write(b, off, len);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
            throw new UnsupportedOperationException();
        }
    }
}

