/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.rest.ParamType;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestParameterException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.AnnotationBaseArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;

@Activate(onClass={"javax.ws.rs.PathParam"})
public class PathParamArgumentResolver
implements AnnotationBaseArgumentResolver<Annotation> {
    @Override
    public Class<Annotation> accept() {
        return Annotations.PathParam.type();
    }

    @Override
    public NamedValueMeta getNamedValueMeta(ParameterMeta parameter, AnnotationMeta<Annotation> annotation) {
        return new NamedValueMeta(annotation.getValue(), true).setParamType(ParamType.PathVariable);
    }

    @Override
    public Object resolve(ParameterMeta parameter, AnnotationMeta<Annotation> annotation, HttpRequest request, HttpResponse response) {
        Map variableMap = (Map)request.attribute("org.springframework.web.servlet.HandlerMapping.uriTemplateVariables");
        String name = annotation.getValue();
        if (StringUtils.isEmpty(name)) {
            name = parameter.getRequiredName();
        }
        if (variableMap == null) {
            if (Helper.isRequired(parameter)) {
                throw new RestParameterException(Messages.ARGUMENT_VALUE_MISSING, name, parameter.getType());
            }
            return null;
        }
        String value = (String)variableMap.get(name);
        if (value == null) {
            return null;
        }
        int index = value.indexOf(59);
        if (index != -1) {
            value = value.substring(0, index);
        }
        return parameter.isAnnotated(Annotations.Encoded) ? value : RequestUtils.decodeURL(value);
    }
}

