/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.dubbo.remoting.http12.HttpCookie;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpUtils;
import org.apache.dubbo.remoting.http12.message.DefaultHttpResult;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Annotations;

public final class Helper {
    private Helper() {
    }

    public static boolean isRequired(ParameterMeta parameter) {
        return parameter.isHierarchyAnnotated(Annotations.Nonnull);
    }

    public static String defaultValue(ParameterMeta parameter) {
        AnnotationMeta meta = parameter.findAnnotation(Annotations.DefaultValue);
        return meta == null ? null : meta.getValue();
    }

    public static HttpResult<Object> toBody(Response response) {
        DefaultHttpResult.Builder<Object> builder = HttpResult.builder().status(response.getStatus());
        if (response.hasEntity()) {
            builder.body(response.getEntity());
        }
        builder.headers((Map<String, List<String>>)response.getStringHeaders());
        return builder.build();
    }

    public static MediaType toMediaType(String mediaType) {
        if (mediaType == null) {
            return null;
        }
        int index = mediaType.indexOf(47);
        if (index == -1) {
            return null;
        }
        return new MediaType(mediaType.substring(0, index), mediaType.substring(index + 1));
    }

    public static String toString(MediaType mediaType) {
        return mediaType.getType() + '/' + mediaType.getSubtype();
    }

    public static List<MediaType> toMediaTypes(String accept) {
        return HttpUtils.parseAccept(accept).stream().map(Helper::toMediaType).collect(Collectors.toList());
    }

    public static NewCookie convert(HttpCookie cookie) {
        return new NewCookie(cookie.name(), cookie.value(), cookie.path(), cookie.domain(), null, (int)cookie.maxAge(), cookie.secure(), cookie.httpOnly());
    }
}

