/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.io.IOException;
import java.lang.annotation.Annotation;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.rest.ParamType;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.AnnotationBaseArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;

@Activate(onClass={"org.jboss.resteasy.annotations.Body"})
public class BodyArgumentResolver
implements AnnotationBaseArgumentResolver<Annotation> {
    @Override
    public Class<Annotation> accept() {
        return Annotations.Body.type();
    }

    @Override
    public NamedValueMeta getNamedValueMeta(ParameterMeta parameter, AnnotationMeta<Annotation> annotation) {
        return new NamedValueMeta().setParamType(ParamType.Body);
    }

    @Override
    public Object resolve(ParameterMeta parameter, AnnotationMeta<Annotation> annotation, HttpRequest request, HttpResponse response) {
        Class<?> type = parameter.getActualType();
        if (type == byte[].class) {
            try {
                return StreamUtils.readBytes(request.inputStream());
            }
            catch (IOException e) {
                throw new RestException(e);
            }
        }
        return RequestUtils.decodeBody(request, parameter.getActualGenericType());
    }
}

