/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.basic;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Pair;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.rest.Param;
import org.apache.dubbo.remoting.http12.rest.ParamType;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.CompositeArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.BeanMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

final class BeanArgumentBinder {
    private static final Map<Class<?>, BeanMeta> CACHE = CollectionUtils.newConcurrentHashMap();
    private final CompositeArgumentResolver argumentResolver;

    public BeanArgumentBinder(CompositeArgumentResolver argumentResolver) {
        this.argumentResolver = argumentResolver;
    }

    public Object bind(ParameterMeta paramMeta, HttpRequest request, HttpResponse response) {
        try {
            Object bean;
            BeanMeta beanMeta = BeanArgumentBinder.getBeanMeta(paramMeta);
            if (beanMeta == null) {
                return null;
            }
            BeanMeta.ConstructorMeta constructor = beanMeta.getConstructor();
            BeanMeta.ConstructorParameterMeta[] parameters = constructor.getParameters();
            int len = parameters.length;
            if (len == 0) {
                bean = constructor.newInstance(new Object[0]);
            } else {
                Object[] args = new Object[len];
                for (int i = 0; i < len; ++i) {
                    BeanMeta.ConstructorParameterMeta parameter = parameters[i];
                    args[i] = parameter.isSimple() ? this.argumentResolver.resolve(parameter, request, response) : null;
                }
                bean = constructor.newInstance(args);
            }
            Node root = new Node(paramMeta.getName(), bean, beanMeta);
            for (String paramName : request.parameterNames()) {
                Node current = root;
                List<String> parts = StringUtils.tokenizeToList(paramName, '.');
                int size = parts.size();
                for (int i = 0; i < size && current != null; ++i) {
                    String name = parts.get(i);
                    Pair<String, String> pair = BeanArgumentBinder.parseKeyParam(name);
                    if (pair == null) {
                        current = current.getChild(name);
                        if (i != 0 || current != null || !name.equals(root.name)) continue;
                        current = root;
                        continue;
                    }
                    name = pair.getLeft();
                    if ((current = current.getChild(name)) == null) break;
                    String key = pair.getValue();
                    if (key.isEmpty()) continue;
                    if (Character.isDigit(key.charAt(0))) {
                        try {
                            current = current.getChild(Long.parseLong(key));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    current = current.getChild(key);
                }
                if (current == null) continue;
                Class<?> type = current.paramMeta.getActualType();
                Object value = type.isArray() || Collection.class.isAssignableFrom(type) ? request.parameterValues(paramName) : request.parameter(paramName);
                current.setValue(this.argumentResolver.getArgumentConverter().convert(value, current.paramMeta));
            }
            for (BeanMeta.PropertyMeta propertyMeta : beanMeta.getProperties()) {
                this.resolveParam(propertyMeta, bean, request, response);
            }
            return bean;
        }
        catch (Exception e) {
            throw new RestException(e, Messages.ARGUMENT_BIND_ERROR, paramMeta.getName(), paramMeta.getType());
        }
    }

    private void resolveParam(BeanMeta.NestableParameterMeta meta, Object bean, HttpRequest request, HttpResponse response) {
        AnnotationMeta<Param> param = meta.getAnnotation(Param.class);
        if (param == null || param.getAnnotation().type() == ParamType.Param) {
            return;
        }
        meta.setValue(bean, this.argumentResolver.resolve(meta, request, response));
    }

    private static BeanMeta getBeanMeta(ParameterMeta paramMeta) {
        Class<?> type = paramMeta.getActualType();
        if (paramMeta.isSimple() || Modifier.isAbstract(type.getModifiers())) {
            return null;
        }
        return CACHE.computeIfAbsent(type, k -> paramMeta.getBeanMeta());
    }

    private static Pair<String, String> parseKeyParam(String name) {
        int start;
        int len = name.length();
        if (name.charAt(len - 1) == ']' && (start = name.lastIndexOf(91)) > -1) {
            return Pair.of(name.substring(0, start), name.substring(start + 1, len - 1));
        }
        return null;
    }

    private static final class Node {
        public final String name;
        public BeanMeta.NestableParameterMeta paramMeta;
        public Consumer<Object> setter;
        public Object value;
        public Map<Object, Node> children;
        public BeanMeta beanMeta;

        public Node(String name, BeanMeta.NestableParameterMeta paramMeta, Consumer<Object> setter) {
            this.name = name;
            this.paramMeta = paramMeta;
            this.setter = setter;
        }

        public Node(String name, Object value, BeanMeta beanMeta) {
            this.name = name;
            this.value = value;
            this.beanMeta = beanMeta;
        }

        public Node getChild(String name) {
            Node node;
            if (this.children != null && (node = this.children.get(name)) != null) {
                return node;
            }
            if (this.beanMeta == null) {
                Class<?> type = this.paramMeta.getType();
                if (Map.class.isAssignableFrom(type)) {
                    return this.createChild(name, this.paramMeta.getNestedMeta(), v -> ((Map)this.value).put(name, v));
                }
                return null;
            }
            BeanMeta.PropertyMeta propertyMeta = this.beanMeta.getProperty(name);
            if (propertyMeta != null) {
                return this.createChild(name, propertyMeta, v -> propertyMeta.setValue(this.value, v));
            }
            return null;
        }

        public Node getChild(long num) {
            Node child;
            Node node;
            if (this.children != null && (node = this.children.get(num)) != null) {
                return node;
            }
            BeanMeta.NestableParameterMeta nestedMeta = this.paramMeta.getNestedMeta();
            Class<?> type = this.paramMeta.getType();
            Object childValue = null;
            if (List.class.isAssignableFrom(type)) {
                int index = (int)num;
                List list = (List)this.value;
                child = new Node(this.name, nestedMeta, v -> {
                    if (index < 0) {
                        return;
                    }
                    while (list.size() <= index) {
                        list.add(null);
                    }
                    list.set(index, v);
                });
                if (index < list.size()) {
                    childValue = list.get(index);
                }
            } else if (type.isArray()) {
                int index = (int)num;
                int len = Array.getLength(this.value);
                child = new Node(this.name, nestedMeta, v -> {
                    if (num >= 0L && num < (long)len) {
                        Array.set(this.value, index, v);
                        return;
                    }
                    int tail = index < 0 ? len : index;
                    Object newArr = Array.newInstance(this.value.getClass().getComponentType(), tail + 1);
                    System.arraycopy(this.value, 0, newArr, 0, len);
                    Array.set(newArr, tail, v);
                    this.setter.accept(newArr);
                });
                if (index < len) {
                    childValue = Array.get(this.value, index);
                }
            } else if (Map.class.isAssignableFrom(type)) {
                Class<?> keyType = TypeUtils.getNestedActualType(this.paramMeta.getGenericType(), 0);
                Object key = TypeUtils.longToObject(num, keyType);
                child = new Node(this.name, nestedMeta, v -> ((Map)this.value).put(key, v));
                childValue = ((Map)this.value).get(key);
            } else {
                return null;
            }
            if (childValue == null) {
                childValue = this.createValue(nestedMeta.getType());
                if (childValue == null) {
                    if (nestedMeta.isSimple()) {
                        return child;
                    }
                    BeanMeta beanMeta = BeanArgumentBinder.getBeanMeta(nestedMeta);
                    if (beanMeta == null) {
                        return null;
                    }
                    child.beanMeta = beanMeta;
                    childValue = beanMeta.newInstance();
                }
                child.setter.accept(childValue);
            } else {
                child.beanMeta = BeanArgumentBinder.getBeanMeta(nestedMeta);
            }
            this.putChild(child, num, childValue);
            return child;
        }

        public void setValue(Object value) {
            this.setter.accept(value);
        }

        private Node createChild(String name, BeanMeta.NestableParameterMeta paramMeta, Consumer<Object> setter) {
            Class<?> type = paramMeta.getType();
            if (type.isArray()) {
                Consumer<Object> arraySetter = setter;
                setter = v -> {
                    arraySetter.accept(v);
                    if (this.children != null) {
                        this.children.get((Object)name).value = v;
                    }
                };
            }
            Node child = new Node(name, paramMeta, setter);
            Object childValue = paramMeta.getValue(this.value);
            boolean created = false;
            if (childValue == null) {
                if (this.value instanceof Map && (childValue = ((Map)this.value).get(name)) != null) {
                    child.beanMeta = BeanArgumentBinder.getBeanMeta(paramMeta);
                }
                if (childValue == null) {
                    childValue = this.createValue(type);
                    if (childValue == null) {
                        if (paramMeta.isSimple()) {
                            return child;
                        }
                    } else {
                        created = true;
                    }
                }
            }
            if (childValue == null) {
                BeanMeta beanMeta = BeanArgumentBinder.getBeanMeta(paramMeta);
                if (beanMeta == null) {
                    return null;
                }
                child.beanMeta = beanMeta;
                childValue = beanMeta.newInstance();
                created = true;
            }
            if (created) {
                setter.accept(childValue);
            }
            this.putChild(child, name, childValue);
            return child;
        }

        private Object createValue(Class<?> type) {
            if (Map.class.isAssignableFrom(type)) {
                return TypeUtils.createMap(type);
            }
            if (Collection.class.isAssignableFrom(type)) {
                return TypeUtils.createCollection(type);
            }
            if (type.isArray()) {
                return Array.newInstance(type.getComponentType(), 1);
            }
            return null;
        }

        private void putChild(Node child, Object name, Object value) {
            child.value = value;
            if (this.children == null) {
                this.children = new HashMap<Object, Node>();
            }
            this.children.put(name, child);
        }
    }
}

