/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.dubbo.config.nested.OpenAPIConfig;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Components;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.ExternalDocs;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Info;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Operation;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.PathItem;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.SecurityRequirement;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Server;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Tag;

public final class OpenAPI
extends Node<OpenAPI> {
    private String openapi;
    private Info info;
    private List<Server> servers;
    private Map<String, PathItem> paths;
    private Components components;
    private List<SecurityRequirement> security;
    private List<Tag> tags;
    private ExternalDocs externalDocs;
    private String group;
    private int priority;
    private transient OpenAPIConfig globalConfig;
    private transient OpenAPIConfig config;
    private transient ServiceMeta meta;

    public String getOpenapi() {
        return this.openapi;
    }

    public OpenAPI setOpenapi(String openapi) {
        this.openapi = openapi;
        return this;
    }

    public Info getInfo() {
        return this.info;
    }

    public OpenAPI setInfo(Info info) {
        this.info = info;
        return this;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public OpenAPI setServers(List<Server> servers) {
        this.servers = servers;
        return this;
    }

    public OpenAPI addServer(Server server) {
        List<Server> thisServers = this.servers;
        if (thisServers == null) {
            this.servers = thisServers = new ArrayList<Server>();
        } else {
            int size = thisServers.size();
            for (int i = 0; i < size; ++i) {
                if (!thisServers.get(i).getUrl().equals(server.getUrl())) continue;
                return this;
            }
        }
        thisServers.add(server);
        return this;
    }

    public OpenAPI removeServer(Server server) {
        if (this.servers != null) {
            this.servers.remove(server);
        }
        return this;
    }

    public Map<String, PathItem> getPaths() {
        return this.paths;
    }

    public PathItem getPath(String path) {
        return this.paths == null ? null : this.paths.get(path);
    }

    public PathItem getOrAddPath(String path) {
        if (this.paths == null) {
            this.paths = new LinkedHashMap<String, PathItem>();
        }
        return this.paths.computeIfAbsent(path, k -> new PathItem());
    }

    public OpenAPI setPaths(Map<String, PathItem> paths) {
        this.paths = paths;
        return this;
    }

    public OpenAPI addPath(String path, PathItem pathItem) {
        if (this.paths == null) {
            this.paths = new LinkedHashMap<String, PathItem>();
        }
        this.paths.put(path, pathItem);
        return this;
    }

    public OpenAPI removePath(String path) {
        if (this.paths != null) {
            this.paths.remove(path);
        }
        return this;
    }

    public Components getComponents() {
        return this.components;
    }

    public OpenAPI setComponents(Components components) {
        this.components = components;
        return this;
    }

    public List<SecurityRequirement> getSecurity() {
        return this.security;
    }

    public OpenAPI setSecurity(List<SecurityRequirement> security) {
        this.security = security;
        return this;
    }

    public OpenAPI addSecurity(SecurityRequirement securityRequirement) {
        if (this.security == null) {
            this.security = new ArrayList<SecurityRequirement>();
        }
        this.security.add(securityRequirement);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public OpenAPI setTags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    public OpenAPI addTag(Tag tag) {
        List<Tag> thisTags = this.tags;
        if (thisTags == null) {
            this.tags = thisTags = new ArrayList<Tag>();
        } else {
            int size = thisTags.size();
            for (int i = 0; i < size; ++i) {
                if (!thisTags.get(i).getName().equals(tag.getName())) continue;
                return this;
            }
        }
        thisTags.add(tag);
        return this;
    }

    public OpenAPI removeTag(Tag tag) {
        if (this.tags != null) {
            this.tags.remove(tag);
        }
        return this;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public OpenAPI setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public OpenAPI setGroup(String group) {
        this.group = group;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public OpenAPI setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public OpenAPIConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public OpenAPI setGlobalConfig(OpenAPIConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public OpenAPIConfig getConfig() {
        return this.config;
    }

    public OpenAPI setConfig(OpenAPIConfig config) {
        this.config = config;
        return this;
    }

    public <T> T getConfigValue(Function<OpenAPIConfig, T> fn) {
        T value;
        if (this.config != null && (value = fn.apply(this.config)) != null) {
            return value;
        }
        return this.globalConfig == null ? null : (T)fn.apply(this.globalConfig);
    }

    public String getConfigSetting(String key) {
        return this.getConfigValue(config -> config == null ? null : config.getSetting(key));
    }

    public void walkOperations(Consumer<Operation> consumer) {
        Map<String, PathItem> paths = this.paths;
        if (paths == null) {
            return;
        }
        for (PathItem pathItem : paths.values()) {
            Map<HttpMethods, Operation> operations = pathItem.getOperations();
            if (operations == null) continue;
            for (Operation operation : operations.values()) {
                consumer.accept(operation);
            }
        }
    }

    public ServiceMeta getMeta() {
        return this.meta;
    }

    public OpenAPI setMeta(ServiceMeta meta) {
        this.meta = meta;
        return this;
    }

    @Override
    public OpenAPI clone() {
        OpenAPI clone = (OpenAPI)super.clone();
        clone.info = OpenAPI.clone(this.info);
        clone.servers = OpenAPI.clone(this.servers);
        clone.paths = OpenAPI.clone(this.paths);
        clone.components = OpenAPI.clone(this.components);
        clone.security = OpenAPI.clone(this.security);
        clone.tags = OpenAPI.clone(this.tags);
        clone.externalDocs = OpenAPI.clone(this.externalDocs);
        return clone;
    }

    @Override
    public Map<String, Object> writeTo(Map<String, Object> node, Context context) {
        node.put("openapi", this.openapi == null ? "3.0.1" : this.openapi);
        OpenAPI.write(node, "info", this.info, context);
        OpenAPI.write(node, "servers", this.servers, context);
        OpenAPI.write(node, "paths", this.paths, context);
        OpenAPI.write(node, "components", this.components, context);
        OpenAPI.write(node, "security", this.security, context);
        OpenAPI.write(node, "tags", this.tags, context);
        OpenAPI.write(node, "externalDocs", this.externalDocs, context);
        this.writeExtensions(node);
        return node;
    }
}

