/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RadixTree;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.BeanMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.TypeParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ConfigFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ExtensionFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPISchemaPredicate;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPISchemaResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.PrimitiveSchema;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Schema;
import org.apache.dubbo.rpc.protocol.tri.rest.support.basic.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public final class SchemaResolver {
    private final ConfigFactory configFactory;
    private final OpenAPISchemaResolver[] resolvers;
    private final OpenAPISchemaPredicate[] predicates;
    private final Map<Class<?>, Schema> schemaMap = CollectionUtils.newConcurrentHashMap();
    private volatile RadixTree<Boolean> classFilter;

    public SchemaResolver(FrameworkModel frameworkModel) {
        this.configFactory = frameworkModel.getOrRegisterBean(ConfigFactory.class);
        ExtensionFactory extensionFactory = frameworkModel.getOrRegisterBean(ExtensionFactory.class);
        this.resolvers = (OpenAPISchemaResolver[])extensionFactory.getExtensions(OpenAPISchemaResolver.class);
        this.predicates = (OpenAPISchemaPredicate[])extensionFactory.getExtensions(OpenAPISchemaPredicate.class);
    }

    public Schema resolve(Type type) {
        return this.resolve(new TypeParameterMeta(type));
    }

    public Schema resolve(ParameterMeta parameter) {
        return new SchemaChainImpl(this.resolvers, this::fallbackResolve).resolve(parameter, new SchemaContextImpl());
    }

    public Schema resolve(List<ParameterMeta> parameters) {
        Schema schema = PrimitiveSchema.OBJECT.newSchema();
        for (ParameterMeta parameter : parameters) {
            String name = parameter.getName();
            if (name == null) {
                return PrimitiveSchema.ARRAY.newSchema();
            }
            schema.addProperty(name, this.resolve(parameter));
        }
        return schema;
    }

    private Schema fallbackResolve(ParameterMeta parameter) {
        return this.doResolveType(parameter.getActualGenericType(), parameter);
    }

    private Schema doResolveNestedType(Type nestedType, ParameterMeta parameter) {
        return this.doResolveType(nestedType, new TypeParameterMeta(parameter.getToolKit(), nestedType));
    }

    private Schema doResolveType(Type type, ParameterMeta parameter) {
        ParameterizedType pType;
        Type rawType;
        if (type instanceof Class) {
            return this.doResolveClass((Class)type, parameter);
        }
        if (type instanceof ParameterizedType && (rawType = (pType = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class clazz = (Class)rawType;
            Type[] argTypes = pType.getActualTypeArguments();
            if (Iterable.class.isAssignableFrom(clazz)) {
                Type itemType = TypeUtils.getActualGenericType(argTypes[0]);
                return ((Schema)PrimitiveSchema.ARRAY.newSchema().addExtension("x-java-class", TypeUtils.toTypeString(type))).setItems(this.doResolveNestedType(itemType, parameter));
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return ((Schema)PrimitiveSchema.OBJECT.newSchema().addExtension("x-java-class", TypeUtils.toTypeString(type))).setAdditionalPropertiesSchema(this.doResolveNestedType(argTypes[1], parameter));
            }
            return this.doResolveClass(clazz, parameter);
        }
        if (type instanceof TypeVariable) {
            return this.doResolveNestedType(((TypeVariable)type).getBounds()[0], parameter);
        }
        if (type instanceof WildcardType) {
            return this.doResolveNestedType(((WildcardType)type).getUpperBounds()[0], parameter);
        }
        if (type instanceof GenericArrayType) {
            return ((Schema)PrimitiveSchema.ARRAY.newSchema().addExtension("x-java-class", TypeUtils.toTypeString(type))).setItems(this.doResolveNestedType(((GenericArrayType)type).getGenericComponentType(), parameter));
        }
        return PrimitiveSchema.OBJECT.newSchema();
    }

    private Schema doResolveClass(Class<?> clazz, ParameterMeta parameter) {
        Schema schema = PrimitiveSchema.newSchemaOf(clazz);
        if (schema != null) {
            return schema;
        }
        if (clazz.isArray()) {
            schema = PrimitiveSchema.ARRAY.newSchema();
            if (!PrimitiveSchema.isPrimitive(clazz.getComponentType())) {
                schema.addExtension("x-java-class", TypeUtils.toTypeString(clazz));
            }
            return schema.setItems(this.doResolveNestedType(clazz.getComponentType(), parameter));
        }
        Schema existingSchema = this.schemaMap.get(clazz);
        if (existingSchema != null) {
            return new Schema().setTargetSchema(existingSchema);
        }
        if (this.isClassExcluded(clazz)) {
            schema = (Schema)PrimitiveSchema.OBJECT.newSchema().addExtension("x-java-class", TypeUtils.toTypeString(clazz));
            this.schemaMap.put(clazz, schema);
            return schema;
        }
        TypeParameterMeta typeParameter = new TypeParameterMeta(clazz);
        for (OpenAPISchemaPredicate predicate : this.predicates) {
            Boolean accepted = predicate.acceptClass(clazz, typeParameter);
            if (accepted == null) continue;
            if (accepted.booleanValue()) break;
            schema = (Schema)PrimitiveSchema.OBJECT.newSchema().addExtension("x-java-class", TypeUtils.toTypeString(clazz));
            this.schemaMap.put(clazz, schema);
            return schema;
        }
        if (clazz.isEnum()) {
            schema = PrimitiveSchema.STRING.newSchema().setJavaType(clazz);
            for (OpenAPISchemaPredicate value : clazz.getEnumConstants()) {
                schema.addEnumeration(value);
            }
            this.schemaMap.put(clazz, schema);
            return schema.clone();
        }
        Boolean flatten = this.configFactory.getGlobalConfig().getSchemaFlatten();
        if (flatten == null) {
            AnnotationMeta anno = typeParameter.getAnnotation(Annotations.Schema);
            flatten = anno != null && anno.getBoolean("flatten");
        }
        return new Schema().setTargetSchema(this.doResolveBeanClass(parameter.getToolKit(), clazz, flatten));
    }

    private Schema doResolveBeanClass(RestToolKit toolKit, Class<?> clazz, boolean flatten) {
        Schema beanSchema = PrimitiveSchema.OBJECT.newSchema().setJavaType(clazz);
        this.schemaMap.put(clazz, beanSchema);
        BeanMeta beanMeta = new BeanMeta(toolKit, clazz, flatten);
        block0: for (BeanMeta.PropertyMeta property : beanMeta.getProperties()) {
            int visibility;
            boolean fallback = true;
            for (OpenAPISchemaPredicate predicate : this.predicates) {
                Boolean accepted = predicate.acceptProperty(beanMeta, property);
                if (accepted == null) continue;
                if (!accepted.booleanValue()) continue block0;
                fallback = false;
                break;
            }
            if (fallback && (((visibility = property.getVisibility()) & 1) == 0 || (visibility & 6) == 0)) continue;
            beanSchema.addProperty(property.getName(), this.resolve(property));
        }
        if (flatten) {
            return beanSchema;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null || superClass == Object.class || TypeUtils.isSystemType(superClass)) {
            return beanSchema;
        }
        return beanSchema.addAllOf(this.resolve(superClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClassExcluded(Class<?> clazz) {
        List<RadixTree.Match<Boolean>> matches;
        int size;
        RadixTree<Boolean> classFilter = this.classFilter;
        if (classFilter == null) {
            SchemaResolver schemaResolver = this;
            synchronized (schemaResolver) {
                classFilter = this.classFilter;
                if (classFilter == null) {
                    classFilter = new RadixTree('.');
                    for (String prefix : TypeUtils.getSystemPrefixes()) {
                        SchemaResolver.addPath(classFilter, prefix);
                    }
                    String[] excludes = this.configFactory.getGlobalConfig().getSchemaClassExcludes();
                    if (excludes != null) {
                        for (String exclude : excludes) {
                            SchemaResolver.addPath(classFilter, exclude);
                        }
                    }
                    this.classFilter = classFilter;
                }
            }
        }
        if ((size = (matches = classFilter.match('.' + clazz.getName())).size()) == 0) {
            return false;
        }
        if (size > 1) {
            Collections.sort(matches);
        }
        return matches.get(0).getValue();
    }

    public static void addPath(RadixTree<Boolean> tree, String path) {
        if (path == null) {
            return;
        }
        int size = path.length();
        if (size == 0) {
            return;
        }
        boolean value = true;
        if (path.charAt(0) == '!') {
            path = path.substring(1);
            --size;
            value = false;
        }
        if (path.charAt(size - 1) == '.') {
            path = path + "**";
        }
        tree.addPath(path, (Boolean)value);
    }

    private static final class SchemaChainImpl
    implements OpenAPISchemaResolver.SchemaChain {
        private final OpenAPISchemaResolver[] resolvers;
        private final Function<ParameterMeta, Schema> fallback;
        private int cursor;

        SchemaChainImpl(OpenAPISchemaResolver[] resolvers, Function<ParameterMeta, Schema> fallback) {
            this.resolvers = resolvers;
            this.fallback = fallback;
        }

        @Override
        public Schema resolve(ParameterMeta parameter, OpenAPISchemaResolver.SchemaContext context) {
            if (this.cursor < this.resolvers.length) {
                return this.resolvers[this.cursor++].resolve(parameter, context, this);
            }
            return this.fallback.apply(parameter);
        }
    }

    private final class SchemaContextImpl
    implements OpenAPISchemaResolver.SchemaContext {
        private SchemaContextImpl() {
        }

        @Override
        public void defineSchema(Class<?> type, Schema schema) {
            SchemaResolver.this.schemaMap.putIfAbsent(type, schema);
        }

        @Override
        public Schema resolve(ParameterMeta parameter) {
            return SchemaResolver.this.resolve(parameter);
        }

        @Override
        public Schema resolve(Type type) {
            return SchemaResolver.this.resolve(type);
        }
    }
}

