/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.rest.OpenAPIRequest;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ContextImpl;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ExtensionFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPIFilter;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.SchemaResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.ApiResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Components;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Header;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.MediaType;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.OpenAPI;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Operation;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Parameter;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.PathItem;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.RequestBody;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Schema;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.SecurityScheme;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Server;

final class DefinitionFilter {
    private final ExtensionFactory extensionFactory;
    private final SchemaResolver schemaResolver;

    public DefinitionFilter(FrameworkModel frameworkModel) {
        this.extensionFactory = frameworkModel.getOrRegisterBean(ExtensionFactory.class);
        this.schemaResolver = frameworkModel.getOrRegisterBean(SchemaResolver.class);
    }

    public OpenAPI filter(OpenAPI openAPI, OpenAPIRequest request) {
        OpenAPIFilter[] filters = (OpenAPIFilter[])this.extensionFactory.getExtensions(OpenAPIFilter.class, request.getGroup());
        ContextImpl context = new ContextImpl(openAPI, this.schemaResolver, this.extensionFactory, request);
        if (filters.length > 0) {
            for (OpenAPIFilter filter : filters) {
                if ((openAPI = filter.filterOpenAPI(openAPI, context)) != null) continue;
                return null;
            }
            this.filterPaths(openAPI, filters, context);
            this.filterComponents(openAPI, filters, context);
            for (OpenAPIFilter filter : filters) {
                if ((openAPI = filter.filterOpenAPICompletion(openAPI, context)) != null) continue;
                return null;
            }
        }
        DefinitionFilter.filterServer(openAPI, context);
        return openAPI;
    }

    private static void filterServer(OpenAPI openAPI, Context context) {
        List<Server> servers = openAPI.getServers();
        if (servers == null || servers.size() != 1) {
            return;
        }
        Server server = servers.get(0);
        if (!"Dubbo Default Server".equals(server.getDescription())) {
            return;
        }
        HttpRequest httpRequest = context.getHttpRequest();
        if (httpRequest == null) {
            return;
        }
        String host = httpRequest.serverHost();
        if (host == null) {
            return;
        }
        String referer = httpRequest.header("referer");
        if (referer != null && referer.contains(host)) {
            servers.clear();
        } else {
            server.setUrl(httpRequest.scheme() + "://" + host);
        }
    }

    private void filterPaths(OpenAPI openAPI, OpenAPIFilter[] filters, Context context) {
        Map<String, PathItem> paths = openAPI.getPaths();
        if (paths == null) {
            return;
        }
        Iterator<Map.Entry<String, PathItem>> it = paths.entrySet().iterator();
        block0: while (it.hasNext()) {
            PathItem pathItem;
            Map.Entry<String, PathItem> entry = it.next();
            PathItem initialPathItem = pathItem = entry.getValue();
            for (OpenAPIFilter filter : filters) {
                pathItem = filter.filterPathItem(entry.getKey(), pathItem, context);
                if (pathItem != null) continue;
                it.remove();
                continue block0;
            }
            if (pathItem != initialPathItem) {
                entry.setValue(pathItem);
            }
            this.filterOperation(pathItem, filters, context);
        }
    }

    private void filterOperation(PathItem pathItem, OpenAPIFilter[] filters, Context context) {
        Map<HttpMethods, Operation> operations = pathItem.getOperations();
        if (operations == null) {
            return;
        }
        Iterator<Map.Entry<HttpMethods, Operation>> it = operations.entrySet().iterator();
        block0: while (it.hasNext()) {
            Operation operation;
            Map.Entry<HttpMethods, Operation> entry = it.next();
            HttpMethods httpMethod = entry.getKey();
            Operation initialOperation = operation = entry.getValue();
            for (OpenAPIFilter filter : filters) {
                if ((operation = filter.filterOperation(httpMethod, operation, pathItem, context)) != null) continue;
                it.remove();
                continue block0;
            }
            if (operation != initialOperation) {
                entry.setValue(operation);
            }
            this.filterParameter(operation, filters, context);
            this.filterRequestBody(operation, filters, context);
            this.filterResponse(operation, filters, context);
        }
    }

    private void filterParameter(Operation operation, OpenAPIFilter[] filters, Context context) {
        List<Parameter> parameters = operation.getParameters();
        if (parameters == null) {
            return;
        }
        ListIterator<Parameter> it = parameters.listIterator();
        block0: while (it.hasNext()) {
            Parameter parameter;
            Parameter initialParameter = parameter = it.next();
            for (OpenAPIFilter filter : filters) {
                if ((parameter = filter.filterParameter(parameter, operation, context)) != null) continue;
                it.remove();
                continue block0;
            }
            if (parameter != initialParameter) {
                it.set(parameter);
            }
            this.filterContext(parameter.getContents(), filters, context);
        }
    }

    private void filterRequestBody(Operation operation, OpenAPIFilter[] filters, Context context) {
        RequestBody body = operation.getRequestBody();
        if (body == null) {
            return;
        }
        RequestBody initialRequestBody = body;
        for (OpenAPIFilter filter : filters) {
            if ((body = filter.filterRequestBody(body, operation, context)) != null) continue;
            operation.setRequestBody(null);
            return;
        }
        if (body != initialRequestBody) {
            operation.setRequestBody(body);
        }
        this.filterContext(body.getContents(), filters, context);
    }

    private void filterResponse(Operation operation, OpenAPIFilter[] filters, Context context) {
        Map<String, ApiResponse> responses = operation.getResponses();
        if (responses == null) {
            return;
        }
        Iterator<Map.Entry<String, ApiResponse>> it = responses.entrySet().iterator();
        block0: while (it.hasNext()) {
            ApiResponse response;
            Map.Entry<String, ApiResponse> entry = it.next();
            ApiResponse initialApiResponse = response = entry.getValue();
            for (OpenAPIFilter filter : filters) {
                if ((response = filter.filterResponse(response, operation, context)) != null) continue;
                it.remove();
                continue block0;
            }
            if (response != initialApiResponse) {
                entry.setValue(response);
            }
            this.filterHeader(response, operation, filters, context);
            this.filterContext(response.getContents(), filters, context);
        }
    }

    private void filterHeader(ApiResponse response, Operation operation, OpenAPIFilter[] filters, Context context) {
        Map<String, Header> headers = response.getHeaders();
        if (headers == null) {
            return;
        }
        Iterator<Map.Entry<String, Header>> it = headers.entrySet().iterator();
        block0: while (it.hasNext()) {
            Header header;
            Map.Entry<String, Header> entry = it.next();
            Header initialHeader = header = entry.getValue();
            for (OpenAPIFilter filter : filters) {
                if ((header = filter.filterHeader(header, response, operation, context)) != null) continue;
                it.remove();
                continue block0;
            }
            if (header != initialHeader) {
                entry.setValue(header);
            }
            this.filterSchema(header::getSchema, header::setSchema, header, filters, context);
            Map<String, MediaType> contents = header.getContents();
            if (contents == null) continue;
            for (MediaType content : contents.values()) {
                this.filterSchema(content::getSchema, content::setSchema, content, filters, context);
            }
        }
    }

    private boolean filterContext(Map<String, MediaType> contents, OpenAPIFilter[] filters, Context context) {
        if (contents == null) {
            return true;
        }
        for (MediaType content : contents.values()) {
            this.filterSchema(content::getSchema, content::setSchema, content, filters, context);
        }
        return false;
    }

    private void filterComponents(OpenAPI openAPI, OpenAPIFilter[] filters, Context context) {
        Components components = openAPI.getComponents();
        if (components == null) {
            return;
        }
        this.filterSchemas(components, filters, context);
        this.filterSecuritySchemes(components, filters, context);
    }

    private void filterSchemas(Components components, OpenAPIFilter[] filters, Context context) {
        if (components == null) {
            return;
        }
        Map<String, Schema> schemas = components.getSchemas();
        if (schemas == null) {
            return;
        }
        for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
            this.filterSchema(entry::getValue, entry::setValue, components, filters, context);
        }
    }

    private void filterSchema(Supplier<Schema> getter, Consumer<Schema> setter, Node<?> owner, OpenAPIFilter[] filters, Context context) {
        List<Schema> anyOf;
        List<Schema> oneOf;
        Schema schema = getter.get();
        if (schema == null) {
            return;
        }
        Schema initialSchema = schema;
        for (OpenAPIFilter filter : filters) {
            if ((schema = filter.filterSchema(schema, owner, context)) != null) continue;
            setter.accept(null);
            return;
        }
        if (schema != initialSchema) {
            setter.accept(schema);
        }
        this.filterSchema(schema::getItems, schema::setItems, schema, filters, context);
        Map<String, Schema> properties = schema.getProperties();
        if (properties != null) {
            block1: for (Map.Entry<String, Schema> entry : properties.entrySet()) {
                String name = entry.getKey();
                Schema valueSchema = entry.getValue();
                for (OpenAPIFilter filter : filters) {
                    if ((valueSchema = filter.filterSchemaProperty(name, valueSchema, schema, context)) != null) continue;
                    entry.setValue(null);
                    continue block1;
                }
                this.filterSchema(entry::getValue, entry::setValue, schema, filters, context);
            }
        }
        this.filterSchema(schema::getAdditionalPropertiesSchema, schema::setAdditionalPropertiesSchema, schema, filters, context);
        List<Schema> allOf = schema.getAllOf();
        if (allOf != null) {
            ListIterator<Schema> it = allOf.listIterator();
            while (it.hasNext()) {
                this.filterSchema(it::next, it::set, schema, filters, context);
            }
        }
        if ((oneOf = schema.getOneOf()) != null) {
            ListIterator<Schema> it = oneOf.listIterator();
            while (it.hasNext()) {
                this.filterSchema(it::next, it::set, schema, filters, context);
            }
        }
        if ((anyOf = schema.getAnyOf()) != null) {
            ListIterator<Schema> it = anyOf.listIterator();
            while (it.hasNext()) {
                this.filterSchema(it::next, it::set, schema, filters, context);
            }
        }
        this.filterSchema(schema::getNot, schema::setNot, schema, filters, context);
    }

    private void filterSecuritySchemes(Components components, OpenAPIFilter[] filters, Context context) {
        if (components == null) {
            return;
        }
        Map<String, SecurityScheme> securitySchemes = components.getSecuritySchemes();
        if (securitySchemes == null) {
            return;
        }
        Iterator<Map.Entry<String, SecurityScheme>> it = securitySchemes.entrySet().iterator();
        block0: while (it.hasNext()) {
            SecurityScheme securityScheme;
            Map.Entry<String, SecurityScheme> entry = it.next();
            SecurityScheme initialSecurityScheme = securityScheme = entry.getValue();
            for (OpenAPIFilter filter : filters) {
                if ((securityScheme = filter.filterSecurityScheme(securityScheme, context)) != null) continue;
                it.remove();
                continue block0;
            }
            if (securityScheme == initialSecurityScheme) continue;
            entry.setValue(securityScheme);
        }
    }
}

