/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import org.apache.dubbo.common.utils.StringUtils;

public class ResponseMeta {
    private final Integer status;
    private final String reason;

    public ResponseMeta(Integer status, String reason) {
        this.status = status;
        this.reason = reason;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public static ResponseMeta combine(ResponseMeta self, ResponseMeta other) {
        if (self == null) {
            return other;
        }
        if (other == null) {
            return self;
        }
        Integer status = other.getStatus() == null ? self.status : other.getStatus();
        String reason = other.getReason() == null ? self.reason : other.getReason();
        return new ResponseMeta(status, reason);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResponseMeta{");
        if (this.status != null) {
            sb.append("status=").append(this.status);
        }
        if (StringUtils.isNotEmpty(this.reason)) {
            sb.append(", reason='").append(this.reason).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }
}

