/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.Condition;

public final class MethodsCondition
implements Condition<MethodsCondition, HttpRequest> {
    private final Set<String> methods;

    public MethodsCondition(String ... methods) {
        this.methods = new HashSet<String>(Arrays.asList(methods));
    }

    private MethodsCondition(Set<String> methods) {
        this.methods = methods;
    }

    public Set<String> getMethods() {
        return this.methods;
    }

    @Override
    public MethodsCondition combine(MethodsCondition other) {
        HashSet<String> set = new HashSet<String>(this.methods);
        set.addAll(other.methods);
        return new MethodsCondition(set);
    }

    @Override
    public MethodsCondition match(HttpRequest request) {
        String method = request.method();
        if (HttpMethods.OPTIONS.is(method)) {
            if (request.hasHeader("origin") && request.hasHeader("access-control-request-method")) {
                return new MethodsCondition(HttpMethods.OPTIONS.name());
            }
            return this;
        }
        if (this.methods.contains(method)) {
            return new MethodsCondition(method);
        }
        if (HttpMethods.HEAD.is(method) && this.methods.contains(HttpMethods.GET.name())) {
            return new MethodsCondition(HttpMethods.GET.name());
        }
        return null;
    }

    @Override
    public int compareTo(MethodsCondition other, HttpRequest request) {
        if (other.methods.size() != this.methods.size()) {
            return other.methods.size() - this.methods.size();
        }
        if (this.methods.size() == 1) {
            if (this.methods.contains(HttpMethods.HEAD.name()) && other.methods.contains(HttpMethods.GET.name())) {
                return -1;
            }
            if (this.methods.contains(HttpMethods.GET.name()) && other.methods.contains(HttpMethods.HEAD.name())) {
                return 1;
            }
        }
        return 0;
    }

    public int hashCode() {
        return this.methods.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != MethodsCondition.class) {
            return false;
        }
        return this.methods.equals(((MethodsCondition)obj).methods);
    }

    public String toString() {
        return "MethodsCondition{methods=" + this.methods + '}';
    }
}

