/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpUtils;
import org.apache.dubbo.remoting.http12.message.MediaType;

public final class MediaTypeExpression
implements Comparable<MediaTypeExpression> {
    public static final MediaTypeExpression ALL = new MediaTypeExpression("*", "*");
    public static final List<MediaTypeExpression> ALL_LIST = Collections.singletonList(ALL);
    public static final Comparator<MediaTypeExpression> COMPARATOR = (m1, m2) -> {
        int comparison = MediaTypeExpression.compareQuality(m1, m2);
        if (comparison != 0) {
            return comparison;
        }
        comparison = MediaTypeExpression.compareType(m1.type, m2.type);
        if (comparison != Integer.MIN_VALUE) {
            return comparison;
        }
        comparison = MediaTypeExpression.compareType(m1.subType, m2.subType);
        return comparison == Integer.MIN_VALUE ? 0 : comparison;
    };
    public static final Comparator<MediaTypeExpression> QUALITY_COMPARATOR = MediaTypeExpression::compareQuality;
    private final String type;
    private final String subType;
    private final boolean negated;
    private final float quality;

    private MediaTypeExpression(String type, String subType, float quality, boolean negated) {
        this.type = type;
        this.subType = subType;
        this.quality = quality;
        this.negated = negated;
    }

    public MediaTypeExpression(String type, String subType) {
        this.type = type;
        this.subType = subType;
        this.quality = 1.0f;
        this.negated = false;
    }

    public static List<MediaType> toMediaTypes(List<MediaTypeExpression> expressions) {
        int size = expressions.size();
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(size);
        for (int i = 0; i < size; ++i) {
            MediaTypeExpression expr = expressions.get(i);
            mediaTypes.add(new MediaType(expr.getType(), expr.getSubType()));
        }
        return mediaTypes;
    }

    public static MediaTypeExpression parse(String expr) {
        int subIndex;
        boolean negated;
        if (expr.indexOf(33) == 0) {
            negated = true;
            expr = expr.substring(1);
        } else {
            negated = false;
        }
        if (StringUtils.isEmpty(expr)) {
            return null;
        }
        int index = expr.indexOf(59);
        String mimeType = (index == -1 ? expr : expr.substring(0, index)).trim();
        if ("*".equals(mimeType)) {
            mimeType = "*/*";
        }
        if ((subIndex = mimeType.indexOf(47)) == -1 || subIndex == mimeType.length() - 1) {
            return null;
        }
        String type = mimeType.substring(0, subIndex);
        String subType = mimeType.substring(subIndex + 1);
        if ("*".equals(type) && !"*".equals(subType)) {
            return null;
        }
        return new MediaTypeExpression(type, subType, HttpUtils.parseQuality(expr, index), negated);
    }

    private static int compareType(String type1, String type2) {
        boolean type1IsWildcard = "*".equals(type1);
        boolean type2IsWildcard = "*".equals(type2);
        if (type1IsWildcard && !type2IsWildcard) {
            return 1;
        }
        if (type2IsWildcard && !type1IsWildcard) {
            return -1;
        }
        if (!type1.equals(type2)) {
            return 0;
        }
        return Integer.MIN_VALUE;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public float getQuality() {
        return this.quality;
    }

    private static int compareQuality(MediaTypeExpression m1, MediaTypeExpression m2) {
        return Float.compare(m2.quality, m1.quality);
    }

    public boolean typesEquals(MediaTypeExpression other) {
        return this.type.equalsIgnoreCase(other.type) && this.subType.equalsIgnoreCase(other.subType);
    }

    public boolean match(MediaTypeExpression other) {
        return this.matchMediaType(other) != this.negated;
    }

    private boolean matchMediaType(MediaTypeExpression other) {
        if (other == null) {
            return false;
        }
        if (this.isWildcardType()) {
            return true;
        }
        if (this.type.equals(other.type)) {
            if (this.subType.equals(other.subType)) {
                return true;
            }
            if (this.isWildcardSubtype()) {
                int plusIdx = this.subType.lastIndexOf(43);
                if (plusIdx == -1) {
                    return true;
                }
                int otherPlusIdx = other.subType.indexOf(43);
                if (otherPlusIdx != -1) {
                    String otherSubtypeSuffix;
                    String subTypeNoSuffix = this.subType.substring(0, plusIdx);
                    String subTypeSuffix = this.subType.substring(plusIdx + 1);
                    return subTypeSuffix.equals(otherSubtypeSuffix = other.subType.substring(otherPlusIdx + 1)) && "*".equals(subTypeNoSuffix);
                }
            }
        }
        return false;
    }

    public boolean compatibleWith(MediaTypeExpression other) {
        return this.compatibleWithMediaType(other) != this.negated;
    }

    private boolean compatibleWithMediaType(MediaTypeExpression other) {
        if (other == null) {
            return false;
        }
        if (this.isWildcardType() || other.isWildcardType()) {
            return true;
        }
        if (this.type.equals(other.type)) {
            if (this.subType.equalsIgnoreCase(other.subType)) {
                return true;
            }
            if (this.isWildcardSubtype() || other.isWildcardSubtype()) {
                if (this.subType.equals("*") || other.subType.equals("*")) {
                    return true;
                }
                String thisSuffix = this.getSubtypeSuffix();
                String otherSuffix = other.getSubtypeSuffix();
                if (this.isWildcardSubtype() && thisSuffix != null) {
                    return thisSuffix.equals(other.subType) || thisSuffix.equals(otherSuffix);
                }
                if (other.isWildcardSubtype() && otherSuffix != null) {
                    return this.subType.equals(otherSuffix) || otherSuffix.equals(thisSuffix);
                }
            }
        }
        return false;
    }

    private boolean isWildcardType() {
        return "*".equals(this.type);
    }

    private boolean isWildcardSubtype() {
        return "*".equals(this.subType) || this.subType.startsWith("*+");
    }

    private String getSubtypeSuffix() {
        int suffixIndex = this.subType.lastIndexOf(43);
        if (suffixIndex != -1) {
            return this.subType.substring(suffixIndex + 1);
        }
        return null;
    }

    @Override
    public int compareTo(MediaTypeExpression other) {
        return COMPARATOR.compare(this, other);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subType, this.negated, Float.valueOf(this.quality));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != MediaTypeExpression.class) {
            return false;
        }
        MediaTypeExpression other = (MediaTypeExpression)obj;
        return this.negated == other.negated && Float.compare(this.quality, other.quality) == 0 && Objects.equals(this.type, other.type) && Objects.equals(this.subType, other.subType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.negated) {
            sb.append('!');
        }
        sb.append(this.type).append('/').append(this.subType);
        if (this.quality != 1.0f) {
            sb.append(";q=").append(this.quality);
        }
        return sb.toString();
    }
}

