/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.dubbo.common.utils.Pair;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathExpression;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathSegment;
import org.apache.dubbo.rpc.protocol.tri.rest.util.KeyString;
import org.apache.dubbo.rpc.protocol.tri.rest.util.PathUtils;

public final class RadixTree<T> {
    private final Map<KeyString, List<Match<T>>> directPathMap = new HashMap<KeyString, List<Match<T>>>();
    private final Node<T> root = new Node();
    private final char separator;
    private final boolean caseSensitive;

    public RadixTree(boolean caseSensitive, char separator) {
        this.caseSensitive = caseSensitive;
        this.separator = separator;
    }

    public RadixTree(boolean caseSensitive) {
        this(caseSensitive, '/');
    }

    public RadixTree(char separator) {
        this(true, separator);
    }

    public RadixTree() {
        this(true, '/');
    }

    public T addPath(PathExpression path, T value) {
        if (path.isDirect()) {
            KeyString key = new KeyString(path.getPath(), this.caseSensitive);
            List matches = this.directPathMap.computeIfAbsent(key, k -> new ArrayList());
            int size = matches.size();
            for (int i = 0; i < size; ++i) {
                Match match = (Match)matches.get(i);
                if (!match.getValue().equals(value)) continue;
                return match.getValue();
            }
            matches.add(new Match(path, (Object)value));
            return null;
        }
        Node<T> current = this.root;
        PathSegment[] segments = path.getSegments();
        int len = segments.length;
        for (int i = 0; i < len; ++i) {
            Node<T> child = this.getChild(current, segments[i]);
            if (i == len - 1) {
                List values = ((Node)child).values;
                int size = values.size();
                for (int j = 0; j < size; ++j) {
                    if (!((PathExpression)((Pair)values.get(j)).getLeft()).equals(path)) continue;
                    return (T)((Pair)values.get(j)).getRight();
                }
                values.add(Pair.of(path, value));
            }
            current = child;
        }
        return null;
    }

    public T addPath(String path, T value) {
        if (path == null) {
            return value;
        }
        if (this.separator == '/') {
            path = PathUtils.normalize(path);
        } else if ((path = path.replace(this.separator, '/')).isEmpty() || path.charAt(0) != '/') {
            path = '/' + path;
        }
        return this.addPath(PathExpression.parse(path), value);
    }

    public void addPath(T value, String ... paths) {
        for (String path : paths) {
            this.addPath(path, value);
        }
    }

    private Node<T> getChild(Node<T> current, PathSegment segment) {
        Node child;
        if (segment.getType() == PathSegment.Type.LITERAL) {
            KeyString key;
            Map children = ((Node)current).children;
            child = (Node)children.get(key = new KeyString(segment.getValue(), this.caseSensitive));
            if (child == null) {
                child = new Node();
                children.put(key, child);
            }
        } else {
            Map children = ((Node)current).fuzzyChildren;
            child = (Node)children.get(segment);
            if (child == null) {
                child = new Node();
                children.put(segment, child);
            }
        }
        return child;
    }

    public void remove(Predicate<T> tester) {
        this.directPathMap.entrySet().removeIf(entry -> {
            List values = (List)entry.getValue();
            values.removeIf(match -> tester.test(match.getValue()));
            return values.isEmpty();
        });
        this.removeRecursive(this.root, tester);
    }

    private void removeRecursive(Node<T> current, Predicate<T> tester) {
        ((Node)current).values.removeIf(pair -> tester.test(pair.getValue()));
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(((Node)current).children);
        list.add(((Node)current).fuzzyChildren);
        for (Map children : list) {
            Iterator cit = children.entrySet().iterator();
            while (cit.hasNext()) {
                Node node = (Node)cit.next().getValue();
                this.removeRecursive(node, tester);
                if (!node.isEmpty()) continue;
                cit.remove();
            }
        }
    }

    public void walk(BiConsumer<PathExpression, T> consumer) {
        for (List<Match<T>> matches : this.directPathMap.values()) {
            for (Match<T> match : matches) {
                consumer.accept(match.getExpression(), (PathExpression)match.getValue());
            }
        }
        this.walkRecursive(this.root, consumer);
    }

    private void walkRecursive(Node<T> root, BiConsumer<PathExpression, T> consumer) {
        for (Pair pair : ((Node)root).values) {
            consumer.accept((PathExpression)pair.getLeft(), (PathExpression)pair.getRight());
        }
        for (Node node : ((Node)root).children.values()) {
            this.walkRecursive(node, consumer);
        }
        for (Node node : ((Node)root).fuzzyChildren.values()) {
            this.walkRecursive(node, consumer);
        }
    }

    public void match(KeyString path, List<Match<T>> matches) {
        List<Match<T>> directMatches = this.directPathMap.get(path);
        if (directMatches != null) {
            int size = directMatches.size();
            for (int i = 0; i < size; ++i) {
                matches.add(directMatches.get(i));
            }
        }
        if (((Node)this.root).isLeaf()) {
            return;
        }
        this.matchRecursive(this.root, path, 1, new HashMap<String, String>(), matches);
    }

    public void match(String path, List<Match<T>> matches) {
        this.match(new KeyString(path, this.caseSensitive), matches);
    }

    public List<Match<T>> match(KeyString path) {
        List<Match<T>> matches = this.directPathMap.get(path);
        if (matches == null) {
            if (((Node)this.root).isLeaf()) {
                return Collections.emptyList();
            }
            matches = new ArrayList<Match<T>>();
        } else {
            if (((Node)this.root).isLeaf()) {
                return Collections.unmodifiableList(matches);
            }
            matches = new ArrayList<Match<T>>(matches);
        }
        this.matchRecursive(this.root, path, 1, new HashMap<String, String>(), matches);
        return matches;
    }

    public List<Match<T>> match(String path) {
        return this.match(new KeyString(path, this.caseSensitive));
    }

    public List<Match<T>> matchRelaxed(String path) {
        char ch;
        KeyString keyPath = new KeyString(path, this.caseSensitive);
        ArrayList<Match<T>> matches = new ArrayList<Match<T>>();
        this.match(keyPath, matches);
        if (!matches.isEmpty()) {
            return matches;
        }
        int end = path.length();
        if (end > 1 && path.charAt(end - 1) == '/') {
            this.match(keyPath.subSequence(0, --end), matches);
            if (!matches.isEmpty()) {
                return matches;
            }
        }
        for (int i = end - 1; i >= 0 && (ch = path.charAt(i)) != '/'; --i) {
            if (ch != '.') continue;
            this.match(keyPath.subSequence(0, i), matches);
            if (matches.isEmpty()) continue;
            return matches;
        }
        return matches;
    }

    private void matchRecursive(Node<T> current, KeyString path, int start, Map<String, String> variableMap, List<Match<T>> matches) {
        int end = -2;
        if (!((Node)current).children.isEmpty()) {
            end = path.indexOf(this.separator, start);
            Node child = (Node)((Node)current).children.get(path.subSequence(start, end));
            if (child != null) {
                if (end == -1) {
                    RadixTree.addMatch(child, variableMap, matches);
                } else {
                    this.matchRecursive(child, path, end + 1, variableMap, matches);
                }
            }
        }
        if (((Node)current).fuzzyChildren.isEmpty()) {
            return;
        }
        if (end == -2) {
            end = path.indexOf(this.separator, start);
        }
        LinkedHashMap<String, String> workVariableMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : ((Node)current).fuzzyChildren.entrySet()) {
            PathSegment segment = (PathSegment)entry.getKey();
            if (!segment.match(path, start, end, workVariableMap)) continue;
            workVariableMap.putAll(variableMap);
            Node child = (Node)entry.getValue();
            if (segment.isTailMatching()) {
                RadixTree.addMatch(child, workVariableMap, matches);
            } else if (end == -1) {
                RadixTree.addMatch(child, workVariableMap, matches);
            } else {
                this.matchRecursive(child, path, end + 1, workVariableMap, matches);
            }
            if (workVariableMap.isEmpty()) continue;
            workVariableMap = new LinkedHashMap();
        }
    }

    private static <T> void addMatch(Node<T> node, Map<String, String> variableMap, List<Match<T>> matches) {
        List values = ((Node)node).values;
        if (values.isEmpty()) {
            if (((Node)node).fuzzyChildren.isEmpty()) {
                return;
            }
            for (Map.Entry entry : ((Node)node).fuzzyChildren.entrySet()) {
                if (((PathSegment)entry.getKey()).getType() != PathSegment.Type.WILDCARD_TAIL) continue;
                RadixTree.addMatch((Node)entry.getValue(), variableMap, matches);
            }
            return;
        }
        variableMap = variableMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(variableMap);
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            Pair pair = (Pair)values.get(i);
            matches.add(new Match((PathExpression)pair.getLeft(), pair.getRight(), variableMap));
        }
    }

    public void clear() {
        this.directPathMap.clear();
        ((Node)this.root).clear();
    }

    public boolean isEmpty() {
        return this.directPathMap.isEmpty() && ((Node)this.root).isEmpty();
    }

    private static final class Node<T> {
        private final Map<KeyString, Node<T>> children = new HashMap<KeyString, Node<T>>();
        private final Map<PathSegment, Node<T>> fuzzyChildren = new HashMap<PathSegment, Node<T>>();
        private final List<Pair<PathExpression, T>> values = new ArrayList<Pair<PathExpression, T>>();

        private Node() {
        }

        private boolean isLeaf() {
            return this.children.isEmpty() && this.fuzzyChildren.isEmpty();
        }

        private boolean isEmpty() {
            return this.isLeaf() && this.values.isEmpty();
        }

        private void clear() {
            this.children.clear();
            this.fuzzyChildren.clear();
            this.values.clear();
        }
    }

    public static final class Match<T>
    implements Comparable<Match<T>> {
        private final PathExpression expression;
        private final T value;
        private final Map<String, String> variableMap;

        Match(PathExpression expression, T value, Map<String, String> variableMap) {
            this.expression = expression;
            this.value = value;
            this.variableMap = variableMap;
        }

        private Match(PathExpression expression, T value) {
            this.expression = expression;
            this.value = value;
            this.variableMap = Collections.emptyMap();
        }

        public PathExpression getExpression() {
            return this.expression;
        }

        public T getValue() {
            return this.value;
        }

        public Map<String, String> getVariableMap() {
            return this.variableMap;
        }

        @Override
        public int compareTo(Match<T> other) {
            int comparison = this.expression.compareTo(other.getExpression());
            return comparison == 0 ? this.variableMap.size() - other.variableMap.size() : comparison;
        }
    }
}

