/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.filter;

import java.util.Arrays;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestFilter;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestUtils;

public abstract class AbstractRestFilter<E>
implements RestFilter {
    protected final E extension;

    public AbstractRestFilter(E extension) {
        this.extension = extension;
    }

    @Override
    public int getPriority() {
        return RestUtils.getPriority(this.extension);
    }

    @Override
    public String[] getPatterns() {
        return RestUtils.getPattens(this.extension);
    }

    public String toString() {
        Object[] patterns;
        StringBuilder sb = new StringBuilder("RestFilter{extension=");
        sb.append(this.extension);
        int priority = this.getPriority();
        if (priority != 0) {
            sb.append(", priority=").append(priority);
        }
        if (ArrayUtils.isNotEmpty(patterns = this.getPatterns())) {
            sb.append(", patterns=").append(Arrays.toString(patterns));
        }
        return sb.append('}').toString();
    }
}

