/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h3.negotiation;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.dubbo.netty.shaded.io.netty.channel.Channel;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpMethod;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2Headers;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2HeadersFrame;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2StreamChannel;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import org.apache.dubbo.netty.shaded.io.netty.handler.timeout.ReadTimeoutHandler;
import org.apache.dubbo.netty.shaded.io.netty.util.AsciiString;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.Future;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.TripleConstants;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.transport.H2TransportListener;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleHttp2ClientResponseHandler;

public class NegotiateClientCall {
    private final AbstractConnectionClient connectionClient;
    private final Executor executor;

    public NegotiateClientCall(AbstractConnectionClient connectionClient, Executor executor) {
        this.connectionClient = connectionClient;
        this.executor = executor;
    }

    public CompletableFuture<String> start(URL url) {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            Channel channel = (Channel)this.connectionClient.getChannel(true);
            if (channel == null) {
                future.completeExceptionally(new IllegalStateException("Channel is null"));
                return future;
            }
            Http2StreamChannelBootstrap bootstrap = new Http2StreamChannelBootstrap(channel);
            bootstrap.handler(new ChannelInboundHandlerAdapter(){

                @Override
                public void handlerAdded(ChannelHandlerContext ctx) {
                    ctx.channel().pipeline().addLast(new ReadTimeoutHandler(12L, TimeUnit.SECONDS)).addLast(new TripleHttp2ClientResponseHandler(new Listener(NegotiateClientCall.this.executor, future)));
                }
            });
            Future<Http2StreamChannel> streamFuture = bootstrap.open();
            streamFuture.addListener(f -> {
                if (f.isSuccess()) {
                    ((Http2StreamChannel)streamFuture.getNow()).writeAndFlush(this.buildHeaders(url)).addListener(cf -> {
                        if (cf.isSuccess()) {
                            return;
                        }
                        future.completeExceptionally(cf.cause());
                    });
                    return;
                }
                future.completeExceptionally(f.cause());
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    private Http2HeadersFrame buildHeaders(URL url) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(false);
        boolean ssl = url.getParameter("ssl-enabled", false);
        AsciiString scheme = ssl ? TripleConstants.HTTPS_SCHEME : TripleConstants.HTTP_SCHEME;
        headers.scheme(scheme).authority(url.getAddress()).method(HttpMethod.OPTIONS.asciiName()).path("/").set(TripleHeaderEnum.SERVICE_TIMEOUT.name(), "10000");
        return new DefaultHttp2HeadersFrame(headers, true);
    }

    private static final class Listener
    implements H2TransportListener {
        private final Executor executor;
        private final CompletableFuture<String> future;

        Listener(Executor executor, CompletableFuture<String> future) {
            this.executor = executor;
            this.future = future;
        }

        @Override
        public void onHeader(Http2Headers headers, boolean endStream) {
            HttpResponseStatus status;
            CharSequence line = headers.status();
            if (line != null && (status = HttpResponseStatus.parseLine(line)).code() < 500) {
                CharSequence altSvc = (CharSequence)headers.get(HttpHeaderNames.ALT_SVC.getKey());
                this.executor.execute(() -> this.future.complete(String.valueOf(altSvc)));
                return;
            }
            if (endStream) {
                return;
            }
            this.executor.execute(() -> this.future.completeExceptionally(new RuntimeException("Status: " + line)));
        }

        @Override
        public void onData(ByteBuf data, boolean endStream) {
        }

        @Override
        public void cancelByRemote(long errorCode) {
            this.executor.execute(() -> this.future.completeExceptionally(new RuntimeException("Canceled by remote")));
        }

        @Override
        public void onClose() {
            if (this.future.isDone()) {
                return;
            }
            this.cancelByRemote(TriRpcStatus.CANCELLED.code.code);
        }
    }
}

