/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h3.negotiation;

import java.util.concurrent.Executor;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.netty.shaded.io.netty.channel.Channel;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.call.TripleClientCall;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.Http2TripleClientStream;
import org.apache.dubbo.rpc.protocol.tri.h3.Http3TripleClientStream;
import org.apache.dubbo.rpc.protocol.tri.h3.negotiation.AutoSwitchConnectionClient;
import org.apache.dubbo.rpc.protocol.tri.stream.ClientStream;
import org.apache.dubbo.rpc.protocol.tri.stream.ClientStreamFactory;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleWriteQueue;

@Activate(order=-90, onClass={"org.apache.dubbo.netty.shaded.io.netty.incubator.codec.quic.QuicChannel"})
public class AdaptiveClientStreamFactory
implements ClientStreamFactory {
    @Override
    public ClientStream createClientStream(AbstractConnectionClient client, FrameworkModel frameworkModel, Executor executor, TripleClientCall clientCall, TripleWriteQueue writeQueue) {
        if (client instanceof AutoSwitchConnectionClient) {
            Channel channel = (Channel)client.getChannel(true);
            if (((AutoSwitchConnectionClient)client).isHttp3Connected()) {
                return new Http3TripleClientStream(frameworkModel, executor, channel, (ClientStream.Listener)clientCall, writeQueue);
            }
            return new Http2TripleClientStream(frameworkModel, executor, channel, (ClientStream.Listener)clientCall, writeQueue);
        }
        return null;
    }
}

